import pandas as pd
import csv

df_snli_test = pd.read_csv(
   'snli_test.csv',
   sep=',', quoting=csv.QUOTE_ALL, header=None)

df_mnli_test = pd.read_csv(
   'mnli_test.csv',
   sep=',', quoting=csv.QUOTE_ALL, header=None)


# flatten both dataframes
df_snli_test_flat = pd.concat([df_snli_test[col] for col in df_snli_test])
df_mnli_test_flat = pd.concat([df_mnli_test[col] for col in df_mnli_test])

# append them to each other
df_all_nli = pd.concat([df_snli_test_flat, df_mnli_test_flat])
df_all_nli.to_csv('all_nli_test.csv', index=False, quoting=csv.QUOTE_ALL, header=False)
print("a")