from datasets import load_dataset
import pandas as pd
import csv

#should have 10,000 samples
snli_test = load_dataset('snli',
                         split='test',
                         cache_dir=".",
                         )

df_snli_test = pd.DataFrame(snli_test)
snli_test_export = df_snli_test[['premise', 'hypothesis']]
snli_test_export.to_csv('snli_test.csv', index=False, quoting=csv.QUOTE_ALL, header=False)


# has 9815 samples
mnli_test = load_dataset('multi_nli',
                         split='validation_matched',
                         cache_dir=".",
                         )

df_mnli_test = pd.DataFrame(mnli_test)
mnli_test_export = df_mnli_test[['premise', 'hypothesis']]
mnli_test_export.to_csv('mnli_test.csv', index=False, quoting=csv.QUOTE_ALL, header=False)




