import math
import pickle
import torch
from trainer import CADSR
import os
import numpy as np
import json
import warnings
import pandas as pd
from pathlib import Path
from sklearn.model_selection import train_test_split
from enums import *
import pickle as pkl

dataset = "feynman_II_8_7"
seed = 42

with open("DDSR_settings/GRPO_autoregressive.json") as file:
    kwargs = json.load(file)

torch.manual_seed(seed)
np.random.seed(seed)

df = pd.read_csv(fr"{dataset}\{dataset}.tsv.gz", compression='infer', header=0, sep='\t')
train_df, test_df = train_test_split(df, train_size=0.8, test_size=0.2)
target = "target"
x = train_df.drop(columns=target).to_numpy().T
y = train_df[target].to_numpy()

model = CADSR(len(x), **kwargs)

equ = model.train(x, y, epochs=600, batch=1000, save_timings=True, save_epoch_info=True,
                  save_eq_dict=False, verbose=True, max_runtime=4*3600, termination_acc=None)

model.add_test_info(test_df.drop(columns=target).to_numpy().T, test_df[target].to_numpy())
model.save_results(f"{dataset}_{seed}")
