# i-DQN & i-IQN

## Installation guidelines
Python $3.10$ is required for installing the dependencies.
GPU installation:
```bash
python3 -m venv env_gpu
source env_gpu/bin/activate
pip install --upgrade pip setuptools==44.0.0 wheel==0.38.4
pip install swig==4.2.1
pip install --upgrade "jax[cuda12_pip]==0.4.13" -f https://storage.googleapis.com/jax-releases/jax_cuda_releases.html
pip install -e .
```
To verify the installation, run the tests as:```pytest```


## Code structure
Each folder has a different purpose:
- The _experiments_ folder contains the skeleton of every algorithm (experiments/base/DQN.py). The experiment/atari folder hosts the starting point for each algorithm. The logs and experiment's metrics will be stored in the experiments/atari/figures/{experiment_name}/{game}/{algorithm}/ and out/atari/{experiment_name}/{game}/ folders.
- The _launch\__job_ folder contains the scripts to launch the experiments. Two modes are available: local runs via the files named launch_job/atari/local_{algorihtm}.sh and remote runs via the files named launch_job/atari/cluster_{algorihtm}.sh. The local runs are launched in a tmux terminal, the remote runs are relying on Slurm.
- The _idqn_ folder contains the backbone of the sckeleton. The environments are created from the idqn/environments folder, each algorithm is implemented in the idqn/networks folder, and the code for the replay buffer is stored in idqn/sample_collection.

## Running scripts
Running the script launch_job/atari/specific.sh trains locally an iDQN agent for $200$M frames and $1$ seed on the game Pong. This script was used to generate Figures 6, 7, 8, 12, 13 (left), 14, 15, 16, 17 and 18.