#!/bin/bash

function parse_arguments() {
    while [[ $# -gt 0 ]]; do
        case $1 in
            -e | --environment)
                ENV=$2
                shift
                shift
                ;;
            -a | --algorithm)
                ALGO=$2
                shift
                shift
                ;;
            -fs | --first_seed)
                FIRST_SEED=$2
                shift
                shift
                ;;
            -ls | --last_seed)
                LAST_SEED=$2
                shift
                shift
                ;;
            -b | --deci_adam_b1)
                DECI_ADAM_B=$2
                shift
                shift
                ;;
            -n | --n_critics)
                N_CRITICS=$2
                shift
                shift
                ;;
            -p | --policy_delay)
                POLICY_DELAY=$2
                shift
                shift
                ;;
            -u | --utd)
                UTD=$2
                shift
                shift
                ;;
            -r | --rolling_step_freq)
                ROLLING_STEP=$2
                shift
                shift
                ;;
            -lr | --learning_rate)
                LEARNING_RATE=$2
                shift
                shift
                ;;        
            -ls | --learning_starts)
                LEARNING_STARTS=$2
                shift
                shift
                ;;
            -t | --tau)
                TAU=$2
                shift
                shift
                ;;
            -?*)
                printf 'WARN: Unknown option (ignored): %s\n' "$1" >&2
                shift
                ;;
            ?*)
                printf 'WARN: Unknown option (ignored): %s\n' "$1" >&2
                shift
                ;;
        esac
    done

    if [[ $ENV == "" ]]
    then
        echo "environment name is missing, use -e" >&2
        exit
    elif [[ $ALGO == "" ]]
    then
        echo "algorithm name is missing, use -a" >&2
        exit
    elif ( [[ $FIRST_SEED != "" ]] && [[ $LAST_SEED = "" ]] ) || ( [[ $FIRST_SEED == "" ]] && [[ $LAST_SEED != "" ]] )
    then
        echo "you need to specify the first and last seed, use -fs and -ls" >&2
        exit
    fi
}