#!/bin/bash

source launch_job/parse_arguments.sh
parse_arguments $@

if ! tmux has-session -t train; then
    tmux new-session -d -s train
    echo "Created new tmux session - train"
fi

seed_command="export SLURM_ARRAY_TASK_ID=1"
conda_command="conda activate isac"

if [[ $ENV == "Hopper" ]]
then # parallelize training
    train_command="launch_job/launch_run_multi.sh $@"
else 
    train_command="launch_job/launch_run.sh $@"
fi

tmux send-keys -t train "$seed_command" ENTER "$conda_command" ENTER "$train_command" ENTER