# i-SAC & i-DroQ

## Installation guidelines
Python $3.11$ is required for installing the dependencies.
```bash
conda create -n isac python=3.11.5
conda activate isac
conda install -c nvidia cuda-nvcc=12.3.52

python -m pip install -e .
python -m pip install --upgrade "jax[cuda12_pip]" -f https://storage.googleapis.com/jax-releases/jax_cuda_releases.html
```

## Code structure
Each folder has a different purpose:
- The _train.py_ script contains the skeleton of the SAC algorithm.
- The _launch\__job_ folder contains the scripts to launch the experiments. Two modes are available, local runs via the files named launch_job/local_run.sh and remote runs via the files named launch_job/cluster_run.sh. The local runs are launched in a tmux terminal, the remote runs rely on Slurm.
- The _sbx_ folder contains the backbone of SAC's skeleton. The biggest change coming from i-SAC is implemented in the sbx/sac/sac.py file, where the function _mse_loss_ is responsible for training the networks in a chained manner.

## Running scripts
Running the script launch_job/local_run.sh trains locally an i-SAC agent for $10^{6}$ environment steps and $1$ seed on the Ant environment. This script was used to generate Figures 9, 13(right), 19, 20, and 21.

## Acknowledgements
This project is based on the [Stable-Baselines3](https://github.com/DLR-RM/stable-baselines3) in Jax repository.
