#!/bin/bash

source launch_job/parse_arguments.sh
parse_arguments $@

[ -d out/$ALGO/$ENV ] || mkdir -p out/$ALGO/$ENV

JOB_NAME=$ALGO\_$ENV\_B-$DECI_ADAM_B\_N-$N_CRITICS\_P-$POLICY_DELAY\_U-$UTD\_T_$TAU\_R-$ROLLING_STEP\_L-$LEARNING_RATE\_S-$LEARNING_STARTS
PATH_NAME=out/$ALGO/$ENV/B-$DECI_ADAM_B\_N-$N_CRITICS\_P-$POLICY_DELAY\_U-$UTD\_T_$TAU\_R-$ROLLING_STEP\_L-$LEARNING_RATE\_S-$LEARNING_STARTS\_%a.out

if [[ $ENV == "Hopper" ]]
then # parallelize training
    submission=$(sbatch -J $JOB_NAME --array=1-4 --cpus-per-task=4 --mem-per-cpu=2700M --time=15:00:00 --gres=gpu:1 -p gpu --prefer="rtx3090|a5000" --output=$PATH_NAME launch_job/launch_run_multi.sh $@)
elif [[ $ENV == "Humanoid" || $ENV == "HumanoidStandup" ]]
then # higher memory
    submission=$(sbatch -J $JOB_NAME --array=5-8 --cpus-per-task=2 --mem-per-cpu=4G --time=15:00:00 --gres=gpu:1 -p gpu --prefer="rtx3090|a5000" --output=$PATH_NAME launch_job/launch_run.sh $@)
else
    submission=$(sbatch -J $JOB_NAME --array=1-10 --cpus-per-task=2 --mem-per-cpu=2G --time=15:00:00 --gres=gpu:1 -p gpu --prefer="rtx3090|a5000" --output=$PATH_NAME launch_job/launch_run.sh $@)
fi
