### Prerequisites
- Python >= 3.5
- Pytorch >= 1.3 and torchvision
- You can use the `requirements.txt` file we provide to setup the environment via Anaconda.
```
conda create --name py36 python=3.6
conda install pytorch torchvision -c pytorch
pip3 install -r requirements.txt

```

### Datasets
--Download 5 datasets.
--Partition data sets. Set `DATASET_NAME` to: `cars`, `cub`, `miniImagenet`, `places`, or `plantae`.
```
python3 write_DATASET_NAME_filelist.py
```

### Step1: feature encoder pre-training on seen domains
- Set `MODEL` to: `ResNet10` or `ResNet12`.
- Set `METHOD` to `baseline`.
- Set `DATASET` to: `miniImagenet` or `cub`.
```

python3 train_baseline_gnn.py --model MODEL --method baseline --dataset DATASET --name BASELINE_NAME --train_aug

```

### Step2: training GNN with BASELINE(step1 save BASELINE_NAME) on seen domains
Need train two 1/5-shot and one 2/10-shot GNN model respectively.
- Set `MODEL` to: `ResNet10_ft` or `ResNet12_ft`.
- Set `METHOD` to `gnnnet`.
- Set `DATASET` to: `miniImagenet` or `cub`.
- Set `NUMBER_SHOT` to: `1`, `2`, `5` or `10`.
```
python3 train_baseline_gnn.py  --model MODEL --method METHOD --dataset DATASET --name GNN_NAME --warmup BASELINE_NAME --n_shot NUMBER_SHOT

```

### Step3: training MLP with GNN models(step2 save GNN_NAME) on seen domains
Put two 1/5-shot GNN model and one 2/10-shot GNN model into the MLP_NAME folder.
- Set `MODEL` to: `ResNet10_ft` or `ResNet12_ft`.
- Set `METHOD` to `gnnnet`.
- Set `DATASET` to: `miniImagenet` or `cub`.
- Set `NUMBER_SHOT_FEW` to: `1/5`.
- Set `NUMBER_SHOT_MUCH` to: `2/10`.

```
python3 train_mlp.py  --model MODEL --method METHOD --dataset DATASET --name MLP_NAME --model_few_shot_1 FEW_shot_GNN_MODEL_1 --model_few_shot_2 FEW_shot_GNN_MODEL_2 --model_much_shot_1 MUCH_shot_GNN_MODEL_1 --n_shot_few NUMBER_SHOT_FEW --n_shot_much NUMBER_SHOT_MUCH --train_aug
 
``` 

### Evaluation
Test the framework `METHOD` on `TESTSET`.
Put two 1/5-shot GNN model and two MLP model into the TEST_NAME folder.
- Set `MODEL` to: `ResNet10_ft` or `ResNet12_ft`.
- Set `METHOD` to `gnnnet`.
- Set `NUMBER_SHOT` to: `1` or `5`.
- Specify the saved model you want to evaluate with `--name` (e.g., `--name MLP_NAME` from the above example).
```
python3 test.py --model MODEL --method METHOD --name TEST_NAME --dataset TESTSET --save_gnn_1 GNN_MODEL_1 --save_gnn_2 GNN_MODEL_2 --save_mlp_1 MLP_MODEL_1 --save_mlp_2 MLP_MODEL_2 --n_shot NUMBER_SHOT
```

## Note
- You can change the number of shot (i.e. 1/5 shots) using the argument `--n_shot`.
