import numpy as np
from os import listdir
from os.path import isfile, isdir, join
import os
import random

cwd = os.getcwd()
root_path = join(cwd,'source/mini_imagenet_full_size')
savedir = './'
dataset_list = ['base','val','novel']

for dataset in dataset_list:
    if dataset == 'base':
        data_path = join(root_path, 'train')
    elif dataset == 'val':
        data_path = join(root_path, 'val')
    elif dataset == 'novel':
        data_path = join(root_path, 'test')
    else:
        raise Exception('no such dataset')

    folder_list = [f for f in listdir(data_path) if isdir(join(data_path, f))]
    print('{} dataset contains {} categories'.format(dataset, len(folder_list)))
    folder_list.sort()
    label_dict = dict(zip(folder_list,range(0,len(folder_list))))

    classfile_list_all = []
    classfile_list_all_0_400 = []
    classfile_list_all_200_600 = []

    for i, folder in enumerate(folder_list[:5]):
        folder_path = join(data_path, folder)
        classfile_list_all.append( [join(folder_path, cf) for cf in listdir(folder_path) if (isfile(join(folder_path,cf)) and cf[0] != '.')])
        classfile_list_all_0_400.append([join(folder_path, cf) for cf in listdir(folder_path) if (isfile(join(folder_path, cf)) and cf[0] != '.')])
        classfile_list_all_200_600.append([join(folder_path, cf) for cf in listdir(folder_path) if (isfile(join(folder_path, cf)) and cf[0] != '.')])

        random.shuffle(classfile_list_all[i])
        classfile_list_all_0_400[i] = classfile_list_all[i][:400]
        classfile_list_all_200_600[i] = classfile_list_all[i][200:600]

        assert (len(classfile_list_all_0_400[i]) == 400)
        assert (len(classfile_list_all_200_600[i]) == 400)
        assert (len(classfile_list_all[i]) == 600)

    file_list = []
    label_list = []
    for i, classfile_list in enumerate(classfile_list_all):
        file_list = file_list + classfile_list
        label_list = label_list + np.repeat(i, len(classfile_list)).tolist()

    fo = open(savedir + dataset + ".json", "w")
    fo.write('{"label_names": [')
    fo.writelines(['"%s",' % item for item in folder_list])
    fo.seek(0, os.SEEK_END)
    fo.seek(fo.tell() - 1, os.SEEK_SET)
    fo.write('],')

    fo.write('"image_names": [')
    fo.writelines(['"%s",' % item for item in file_list])
    fo.seek(0, os.SEEK_END)
    fo.seek(fo.tell() - 1, os.SEEK_SET)
    fo.write('],')

    fo.write('"image_labels": [')
    fo.writelines(['%d,' % item for item in label_list])
    fo.seek(0, os.SEEK_END)
    fo.seek(fo.tell() - 1, os.SEEK_SET)
    fo.write(']}')

    fo.close()
    print("%s -OK" % dataset)

    if dataset == 'base':
        file_list = []
        label_list = []
        for i, classfile_list in enumerate(classfile_list_all_0_400):
            file_list = file_list + classfile_list
            label_list = label_list + np.repeat(i, len(classfile_list)).tolist()

        fo = open(savedir + dataset + '_0_400' + ".json", "w")
        fo.write('{"label_names": [')
        fo.writelines(['"%s",' % item for item in folder_list])
        fo.seek(0, os.SEEK_END)
        fo.seek(fo.tell() - 1, os.SEEK_SET)
        fo.write('],')

        fo.write('"image_names": [')
        fo.writelines(['"%s",' % item for item in file_list])
        fo.seek(0, os.SEEK_END)
        fo.seek(fo.tell() - 1, os.SEEK_SET)
        fo.write('],')

        fo.write('"image_labels": [')
        fo.writelines(['%d,' % item for item in label_list])
        fo.seek(0, os.SEEK_END)
        fo.seek(fo.tell() - 1, os.SEEK_SET)
        fo.write(']}')

        fo.close()


        file_list = []
        label_list = []
        for i, classfile_list in enumerate(classfile_list_all_200_600):
            file_list = file_list + classfile_list
            label_list = label_list + np.repeat(i, len(classfile_list)).tolist()

        fo = open(savedir + dataset + '_200_600' + ".json", "w")
        fo.write('{"label_names": [')
        fo.writelines(['"%s",' % item for item in folder_list])
        fo.seek(0, os.SEEK_END)
        fo.seek(fo.tell() - 1, os.SEEK_SET)
        fo.write('],')

        fo.write('"image_names": [')
        fo.writelines(['"%s",' % item for item in file_list])
        fo.seek(0, os.SEEK_END)
        fo.seek(fo.tell() - 1, os.SEEK_SET)
        fo.write('],')

        fo.write('"image_labels": [')
        fo.writelines(['%d,' % item for item in label_list])
        fo.seek(0, os.SEEK_END)
        fo.seek(fo.tell() - 1, os.SEEK_SET)
        fo.write(']}')

        fo.close()
