import numpy as np
from os import listdir
from os.path import isfile, isdir, join
import os
import random

cwd = os.getcwd()
data_path = join(cwd,'source/CUB_200_2011/images')
savedir = './json_split/'
dataset_list = ['base', 'val', 'novel']

#if not os.path.exists(savedir):
#    os.makedirs(savedir)

folder_list = [f for f in listdir(data_path) if isdir(join(data_path, f))]
folder_list.sort()
label_dict = dict(zip(folder_list,range(0,len(folder_list))))

classfile_list_all = []

for i, folder in enumerate(folder_list):
    folder_path = join(data_path, folder)
    classfile_list_all.append( [ join(folder_path, cf) for cf in listdir(folder_path) if (isfile(join(folder_path,cf)) and cf[0] != '.')])
    random.shuffle(classfile_list_all[i])


for dataset in dataset_list:
    file_list = []
    label_list = []
    if dataset == 'base':
        file_list1 = []
        label_list1 = []
        file_list2 = []
        label_list2 = []
    for i, classfile_list in enumerate(classfile_list_all):
        if 'base' in dataset:
            if (i%2 == 0):
                file_list = file_list + classfile_list
                label_list = label_list + np.repeat(i, len(classfile_list)).tolist()
                len_cl = len(classfile_list)
                file_list1 = file_list1 + classfile_list[:len_cl - int(len_cl/3)]
                label_list1 = label_list1 + np.repeat(i, len_cl - int(len_cl/3)).tolist()
                file_list2 = file_list2 + classfile_list[int(len_cl/3):]
                label_list2 = label_list2 + np.repeat(i, int(len_cl/3)).tolist()
        if 'val' in dataset:
            if (i%4 == 1):
                file_list = file_list + classfile_list
                label_list = label_list + np.repeat(i, len(classfile_list)).tolist()
        if 'novel' in dataset:
            if (i%4 == 3):
                file_list = file_list + classfile_list
                label_list = label_list + np.repeat(i, len(classfile_list)).tolist()

    fo = open(savedir + dataset + ".json", "w")
    fo.write('{"label_names": [')
    fo.writelines(['"%s",' % item  for item in folder_list])
    fo.seek(0, os.SEEK_END)
    fo.seek(fo.tell()-1, os.SEEK_SET)
    fo.write('],')

    fo.write('"image_names": [')
    fo.writelines(['"%s",' % item  for item in file_list])
    fo.seek(0, os.SEEK_END)
    fo.seek(fo.tell()-1, os.SEEK_SET)
    fo.write('],')

    fo.write('"image_labels": [')
    fo.writelines(['%d,' % item  for item in label_list])
    fo.seek(0, os.SEEK_END)
    fo.seek(fo.tell()-1, os.SEEK_SET)
    fo.write(']}')

    fo.close()
    print("%s -OK" %dataset)
    if dataset == 'base':
        fo = open(savedir + dataset + "0_2.json", "w")
        fo.write('{"label_names": [')
        fo.writelines(['"%s",' % item for item in folder_list])
        fo.seek(0, os.SEEK_END)
        fo.seek(fo.tell() - 1, os.SEEK_SET)
        fo.write('],')

        fo.write('"image_names": [')
        fo.writelines(['"%s",' % item for item in file_list1])
        fo.seek(0, os.SEEK_END)
        fo.seek(fo.tell() - 1, os.SEEK_SET)
        fo.write('],')

        fo.write('"image_labels": [')
        fo.writelines(['%d,' % item for item in label_list1])
        fo.seek(0, os.SEEK_END)
        fo.seek(fo.tell() - 1, os.SEEK_SET)
        fo.write(']}')

        fo.close()
        print("%s -02OK" % dataset)

        fo = open(savedir + dataset + "1_3.json", "w")
        fo.write('{"label_names": [')
        fo.writelines(['"%s",' % item for item in folder_list])
        fo.seek(0, os.SEEK_END)
        fo.seek(fo.tell() - 1, os.SEEK_SET)
        fo.write('],')

        fo.write('"image_names": [')
        fo.writelines(['"%s",' % item for item in file_list2])
        fo.seek(0, os.SEEK_END)
        fo.seek(fo.tell() - 1, os.SEEK_SET)
        fo.write('],')

        fo.write('"image_labels": [')
        fo.writelines(['%d,' % item for item in label_list2])
        fo.seek(0, os.SEEK_END)
        fo.seek(fo.tell() - 1, os.SEEK_SET)
        fo.write(']}')

        fo.close()
        print("%s -13OK" % dataset)

