# EquiLoPO Repository

This repository contains the implementation of EquiLoPO (Equivariant to Local Patterns Orientation Network), a convolutional neural network architecture that achieves rotational equivariance for volumetric data analysis. The key components of this repository are:

## Repository Structure

- **EquiLoPO/**: Contains the EquiLoPO package, including the implementation of the EquiLoPONet convolution operator and related utilities.
  
- **MedMNIST/**: This directory contains adaptations of ResNet-18 and ResNet-50 architectures that utilize the EquiLoPONet convolution operator. The adaptations are designed to work with the MedMNIST collection, a comprehensive resource for benchmarking machine learning models on medical image datasets. The MedMNIST codebase is sourced from [MedMNIST GitHub Repository](https://github.com/MedMNIST/MedMNIST) and is licensed under the Apache License 2.0.

## Example Commands

### Training and Evaluation

The following commands demonstrate how to train and evaluate models with different activation configurations on the Adrenal dataset of the MedMNIST3D collection.

#### Local Trainable Activation
```bash
python3 ./MedMNIST/experiments/MedMNIST3D/train_and_eval_pytorch.py \
    --data_flag adrenalmnist3d \
    --conv Conv3d \
    --model_flag elporesnet18 \
    --download \
    --output_root ./MedMNIST/experiments/MedMNIST3D/output/ \
    --dropout 0.01 \
    --learning_rate 0.005 \
    --batch_size 16 \
    --order 2 \
    --downsample_by_pooling \
    --coefficients_type trainable \
    --model_path ./MedMNIST/experiments/MedMNIST3D/output/adrenalmnist3d/local_trainable_activation/240131_131536/best_model.pth \ # Evaluate a pre-trained model
    --num_epochs 0 # Evaluate a pre-trained model
```

#### Local Adaptive Activation

```bash
python3 ./MedMNIST/experiments/MedMNIST3D/train_and_eval_pytorch.py \
    --data_flag adrenalmnist3d \
    --conv Conv3d \
    --model_flag elporesnet18 \
    --download \
    --output_root ./MedMNIST/experiments/MedMNIST3D/output/ \
    --dropout 0.01 \
    --learning_rate 0.005 \
    --batch_size 16 \
    --order 2 \
    --downsample_by_pooling \
    --coefficients_type adaptive \
    --gpu_ids -1 \
    --model_path ./MedMNIST/experiments/MedMNIST3D/output/adrenalmnist3d/local_adaptive_activation/240224_080307/best_model.pth \ # Evaluate a pre-trained model
    --num_epochs 0 # Evaluate a pre-trained model
```

#### Global Trainable Activation

```bash
python3 ./MedMNIST/experiments/MedMNIST3D/train_and_eval_pytorch.py \
    --data_flag adrenalmnist3d \
    --conv Conv3d \
    --model_flag elporesnet18 \
    --download \
    --output_root ./MedMNIST/experiments/MedMNIST3D/output/ \
    --dropout 0.01 \
    --learning_rate 0.005 \
    --batch_size 16 \
    --order 2 \
    --downsample_by_pooling \
    --coefficients_type trainable \
    --gpu_ids -1 \
    --global_activation \
    --model_path ./MedMNIST/experiments/MedMNIST3D/output/adrenalmnist3d/global_trainable_activation/240209_180658/best_model.pth \ # Evaluate a pre-trained model
    --num_epochs 0 # Evaluate a pre-trained model
```


#### Running on Other Datasets
To run the model on another dataset from the MedMNIST3D collection, navigate to './MedMNIST/experiments/MedMNIST3D/output/', find the corresponding directory for your desired dataset, and insert the path to the model in the '--model_path' argument.

For example, if you want to evaluate the model on the Nodule dataset, you can find the pre-trained model in './MedMNIST/experiments/MedMNIST3D/output/nodulemnist3d/' and update the '--model_path' accordingly.

