%% For top 50 features we find the cosine similarity across folds for K-SHAP.
clear;
nb = [];
sd = [];
iter = 1;
for m = 1:10
    for k=0:9
        load(sprintf('shap_importance/data_%d/model%d/vis.mat',m,k));
        nb(:,iter) = shap_nback;
        sd(:,iter) = shap_sdmt;
        iter = iter + 1;
    end
end


%% For NBACK
[~,n] = maxk(nb,50);
w = zeros(246,iter-1);

for i=1:iter-1
w(n(:,i),i)=1;
end
D = 1-pdist2(w',w','cosine');
p_nback = upper(D);




%% For SDMT
[~,n] = maxk(sd,50);
w = zeros(246,iter-1);

for i=1:iter-1
w(n(:,i),i)=1;
end
D = 1-pdist2(w',w','cosine');
p_sdmt = upper(D);


function res= upper(A)
res = [];
for i=1:size(A,1)
    for j=i:size(A,2)
        if i~=j
         res = [res,A(i,j)];
        end
    end
end


end




