%%  Perform FDR and find the most significant set of pathways.
clear;
fina =[];
for pid = 1:10 % pid=[1:10] since we have performed 10 subsamplings.
    s = dir(sprintf('interactions/pretrain%d/model/',pid));
    arr = [];
    for i = 3:length(s)
        load(sprintf('interactions/pretrain%d/model/%s',pid,s(i).name));
        arr(i) = pval;
    end
    arr=arr(3:end);
    p_change = mafdr(arr,'BHFDR','True');
    final(:,pid) = p_change;
end

app = sum(final<0.05,2);

% Find interactions that are significant most of the times.
maj = find(app>6); 

% Load Ontology.
go = geneont_mod('live',true);

% Terms contain the name of GO terms.
load(sprintf('../../data/%d_layer_connection.mat',5),'terms','pool_n');

% Create a text file to store the pathway information.
fileID = fopen('exp.txt','w');

for nn = 1:length(maj)
    
load(sprintf('interactions/pretrain1/model/%s',s(maj(nn)+2).name));

t_path = terms(path+1);

for j=1:length(t_path)
name{nn, j} = go(t_path(j)).term.name;
fprintf(fileID,'%s\t',go(t_path(j)).term.name);
end
fprintf(fileID,'\n');
f = median(final(maj(nn),:));
name{nn,j+1} = f;%app(maj(nn));

end
fclose(fileID);



