
import numpy as np

def get_fourier_series2(max_frequence):

    def fourier_series(x,*t):
        sum_ = t[0] #a0
        f  =  t[1]
        for i in range(2,max_frequence+2):
            sum_ += t[i]*np.cos(i*f*x)
        for i in range(2,max_frequence+2):
            i=i+max_frequence
            sum_ += t[i]*np.sin(i*f*x)
        return sum_

    def dfourier_series(x, *t):
        sum_ = 0
        f = t[1]
        for i in range(2, max_frequence + 2):
            sum_ += t[i] * -np.sin(i * f * x)
        for i in range(2, max_frequence + 2):
            i = i + max_frequence
            sum_ += t[i] * np.cos(i * f * x)
        return sum_
    num_params= max_frequence+max_frequence+2
    return fourier_series, dfourier_series, num_params


def get_polynomial2(max_degree):
    def polynomial(x,*t):
        sum_ = 0
        for i in range(max_degree):
            sum_ += x**i*t[i]
        return sum_

    def dpolynomial(x,*t):
        sum_ = 0
        for i in range(1,max_degree):
            sum_ += i*x**(i-1)*t[i]
        return sum_

    num_params= max_degree+1
    return polynomial, dpolynomial, num_params

# def get_linear_spline2(num_splines):
#     functions = []
#     functions.append(lambda x: 0)
#     for i in range(num_splines):
#         f = lambda x,*t: f[-1](x)+t[i]*(x-t[i]) # wird hier kompliziert...





def get_linear_spline(num_splines):
    n=num_splines
    x_params = ["x" + str(x) for x in range(0, n - 1)]
    a_params = ["a" + str(x) for x in range(1, n + 1)]

    a_arguments = ",".join(a_params)
    x_arguments = ",".join(x_params)


    if len(x_params)>0:
        condlist = "[x < x0,"
        for x_pre, x_post in zip(x_params[:-1],x_params[1:]):
            condlist+= "(x >= {0}) & (x < {1}),".format(x_pre,x_post)
        condlist+="x >= {0}]".format(x_params[-1])
    else:
        condlist="[x]"
    funclist = ["lambda x: a1 * x + b"]
    for a,x in zip(a_params[1:],x_params):
        funclist.append(funclist[-1]+" + {0} * (x-{1})".format(a,x))
    funclist = "["+",".join(funclist)+"]"
    #print(funclist)
    if len(x_params) > 0:
        header = "def linear_spline(x,b,{0},{1}): \n ".format(x_arguments,a_arguments)
    else:
        header = "def linear_spline(x,b,{0}): \n ".format(a_arguments)
    body = "\t condlist = {0} \n \t funclist = {1} \n \t return np.piecewise(x, condlist, funclist)".format(condlist,funclist)
    function_string = header + body
    #print(function_string)
    exec(function_string,globals(),globals())


    funclist = ["lambda x: a1"]
    for a,x in zip(a_params[1:],x_params):
        funclist.append(funclist[-1]+" + {0}".format(a))
    funclist = "["+",".join(funclist)+"]"
    #print(funclist)
    if len(x_params) > 0:
        header = "def dlinear_spline(x,b,{0},{1}): \n ".format(x_arguments,a_arguments)
    else:
        header = "def dlinear_spline(x,b,{0}): \n ".format(a_arguments)
    body = "\t condlist = {0} \n \t funclist = {1} \n \t return np.piecewise(x, condlist, funclist)".format(condlist,funclist)
    function_string = header + body
    #print(function_string)
    exec(function_string,globals(),globals())

    return linear_spline, dlinear_spline

def get_cubic_spline(num_splines):
    n = num_splines
    x_params = ["x" + str(x) for x in range(0, n - 1)]
    a_params = ["a" + str(x) for x in range(1, n + 1)]
    b_params = ["b" + str(x) for x in range(1, n + 1)]
    c_params = ["c" + str(x) for x in range(1, n + 1)]

    a_arguments = ",".join(a_params)
    b_arguments = ",".join(b_params)
    c_arguments = ",".join(c_params)
    x_arguments = ",".join(x_params)

    if len(x_params) > 0:
        condlist = "[x < x0,"
        for x_pre, x_post in zip(x_params[:-1], x_params[1:]):
            condlist += "(x >= {0}) & (x < {1}),".format(x_pre, x_post)
        condlist += "x >= {0}]".format(x_params[-1])
    else:
        condlist = "[x]"
    funclist = ["lambda x: c1 * x**3 + b1 * x**2 + a1 * x + d"]
    for a,b,c, x in zip(a_params[1:],b_params[1:],c_params[1:], x_params):
        funclist.append(funclist[-1] + "+{2} * (x-{3})**3 + {1} * (x-{3})**2 + {0} * (x-{3})".format(a,b,c,x))
    funclist = "[" + ",".join(funclist) + "]"
    #print(funclist)
    if len(x_params) > 0:
        header = "def cubic_spline(x,d,{0},{1},{2},{3}): \n ".format(x_arguments, a_arguments,b_arguments,c_arguments)
    else:
        header = "def cubic_spline(x,d,{0},{1},{2}): \n ".format(a_arguments,b_arguments,c_arguments)
    body = "\t condlist = {0} \n \t funclist = {1} \n \t return np.piecewise(x, condlist, funclist)".format(condlist,
                                                                                                            funclist)
    function_string = header + body
    #print(function_string)
    exec(function_string, globals(), globals())

    funclist = ["lambda x: 3*c1 * x**2 + 2 * b1 * x**1 + a1"]
    for a,b,c, x in zip(a_params[1:],b_params[1:],c_params[1:], x_params):
        funclist.append(funclist[-1] + "+3*{2} * (x-{3})**2 + 2 * {1} * (x-{3})**1+ {0}".format(a,b,c,x))
    funclist_string = "[" + ",".join(funclist) + "]"
    #print(funclist)
    if len(x_params) > 0:
        header = "def dcubic_spline(x,d,{0},{1},{2},{3}): \n ".format(x_arguments, a_arguments,b_arguments,c_arguments)
    else:
        header = "def dcubic_spline(x,d,{0},{1},{2}): \n ".format(a_arguments,b_arguments,c_arguments)
    body = "\t condlist = {0} \n \t funclist = {1} \n \t return np.piecewise(x, condlist, funclist)".format(condlist,
                                                                                                            funclist_string)
    function_string = header + body
    exec(function_string, globals(), globals())
    # conditions=[]
    # print(function_string)
    # for i,(f1,f2,x) in enumerate(zip(funclist[:-1],funclist[1:],x_params)):
    #     header = "def condition{4}({0},{1},{2},{3}): \n ".format(x_arguments, a_arguments, b_arguments,
    #                                                                   c_arguments,i)
    #     condition = (f1+" - ("+f2+")")
    #     condition=condition.replace("lambda x:","")
    #     condition=condition.replace("x",x)
    #
    #     condition_add = "\n conditions.append(condition{0}).format(i)"
    #     condition_string = header + condition + condition_add
    #     print(condition_string)
    #     exec(condition_string, globals(), globals())


    #print(function_string)

    return cubic_spline, dcubic_spline


def get_smooth_cubic_spline(num_splines):
    n = num_splines
    x_params = ["x" + str(x) for x in range(0, n - 1)]
    a_params = ["a" + str(x) for x in range(1, 1 + 1)]
    b_params = ["b" + str(x) for x in range(1, 1 + 1)]
    c_params = ["c" + str(x) for x in range(1, n + 1)]

    a_arguments = ",".join(a_params)
    b_arguments = ",".join(b_params)
    c_arguments = ",".join(c_params)
    x_arguments = ",".join(x_params)

    if len(x_params) > 0:
        condlist = "[x < x0,"
        for x_pre, x_post in zip(x_params[:-1], x_params[1:]):
            condlist += "(x >= {0}) & (x < {1}),".format(x_pre, x_post)
        condlist += "x >= {0}]".format(x_params[-1])
    else:
        condlist = "[x]"
    funclist = ["lambda x: c1 * x**3 + b1 * x**2 + a1 * x + d"]
    for c, x in zip(c_params[1:], x_params):
        funclist.append(funclist[-1] + "+{0} * (x-{1})**3".format(c,x))
    funclist = "[" + ",".join(funclist) + "]"
    #print(funclist)
    if len(x_params) > 0:
        header = "def cubic_spline(x,d,{0},{1},{2},{3}): \n ".format(x_arguments, a_arguments,b_arguments,c_arguments)
    else:
        header = "def cubic_spline(x,d,{0},{1},{2}): \n ".format(a_arguments,b_arguments,c_arguments)
    body = "\t condlist = {0} \n \t funclist = {1} \n \t return np.piecewise(x, condlist, funclist)".format(condlist,
                                                                                                            funclist)
    function_string = header + body
    #print(function_string)
    exec(function_string, globals(), globals())

    funclist = ["lambda x: 3*c1 * x**2 + 2 * b1 * x**1 + a1"]
    for c, x in zip(c_params[1:], x_params):
        funclist.append(funclist[-1] + "+3*{0} * (x-{1})**2".format(c,x))
    funclist_string = "[" + ",".join(funclist) + "]"
    #print(funclist)
    if len(x_params) > 0:
        header = "def dcubic_spline(x,d,{0},{1},{2},{3}): \n ".format(x_arguments, a_arguments,b_arguments,c_arguments)
    else:
        header = "def dcubic_spline(x,d,{0},{1},{2}): \n ".format(a_arguments,b_arguments,c_arguments)
    body = "\t condlist = {0} \n \t funclist = {1} \n \t return np.piecewise(x, condlist, funclist)".format(condlist,
                                                                                                            funclist_string)
    function_string = header + body
    exec(function_string, globals(), globals())
    # conditions=[]
    # print(function_string)
    # for i,(f1,f2,x) in enumerate(zip(funclist[:-1],funclist[1:],x_params)):
    #     header = "def condition{4}({0},{1},{2},{3}): \n ".format(x_arguments, a_arguments, b_arguments,
    #                                                                   c_arguments,i)
    #     condition = (f1+" - ("+f2+")")
    #     condition=condition.replace("lambda x:","")
    #     condition=condition.replace("x",x)
    #
    #     condition_add = "\n conditions.append(condition{0}).format(i)"
    #     condition_string = header + condition + condition_add
    #     print(condition_string)
    #     exec(condition_string, globals(), globals())


    #print(function_string)

    return cubic_spline, dcubic_spline


def get_polynomial(max_degree):
    n = max_degree
    args = ",".join("a" + str(x) for x in range(0, n + 1))
    header = "def polynomial(x,{0}): \n ".format(args)
    body = "\t return " + "+".join(["a{0}*x**{0}".format(e) for e in range(0, n + 1)])
    function_string = header + body
    # print(function_string)
    exec(function_string, globals(), globals())

    args = ",".join("a" + str(x) for x in range(0, n + 1))
    header = "def dpolynomial(x,{0}): \n ".format(args)
    body = "\t return " + "+".join(["{0}*a{0}*x**{1}".format(e, e - 1) for e in range(1, n + 1)])
    function_string = header + body
    # print(function_string)
    exec(function_string, globals(), globals())
    return polynomial, dpolynomial

def get_fourier_series(max_frequence):
    n=max_frequence
    cos_arguments= ",".join("a"+str(x) for x in range(1,n+1))
    sin_arguments= ",".join("b"+str(x) for x in range(1,n+1))
    header = "def fourier_series(x,f,a0,{0},{1}): \n ".format(sin_arguments,cos_arguments)
    body = "\t return a0 +" + "+".join(["a{0}*np.cos({0} * f * x) + b{0} * np.sin({0} * f * x)".format(e) for e in range(1,n+1)])
    function_string = header + body
    exec(function_string,globals(),globals())

    header = "def dfourier_series(x,f,a0,{0},{1}): \n ".format(sin_arguments,cos_arguments)
    body = "\t return " + "+".join(["a{0}*{0}*f*-np.sin({0} * f * x) + b{0} *{0} * f * np.cos({0} * f * x)".format(e) for e in range(1,n+1)])
    function_string = header + body
    exec(function_string,globals(),globals())
    #print(function_string)
    return fourier_series, dfourier_series



