#!/bin/bash
# for ENV in hopper-expert-v2
# do
#   for LEARN in behavior
#     do
# #      python ../src/data_process.py --env $ENV --traj $TRAJ --learn $LEARN --proc plot
# #      python ../src/data_process.py --env $ENV --traj $TRAJ --learn $LEARN --proc pfm
#        CUDA_VISIBLE_DEVICES=1 python ../src/rlhf_training.py --env $ENV --learn $LEARN
#     done
# done


# CUDA_VISIBLE_DEVICES=0 python train.py --env halfcheetah-medium-v2 --learn naive-behavior-ppo
#CUDA_VISIBLE_DEVICES=3 python train.py --env walker2d-expert-v2 --learn orl
# CUDA_VISIBLE_DEVICES=2 python train.py --env walker2d-medium-v2 --learn brac

# CUDA_VISIBLE_DEVICES=2 python ../src/train.py --env halfcheetah-expert-v2 --learn brac

# CUDA_VISIBLE_DEVICES=2 python ../src/train.py --env halfcheetah-expert-v2 --learn reward

# CUDA_VISIBLE_DEVICES=2 python train.py --env halfcheetah-expert-v2 --learn brac

#!/bin/bash

CUDA_DEVICES=(0 2 3)  # List of available CUDA devices
i=0
session_count=1

for ENV in hopper-expert-v2 halfcheetah-medium-v2 walker2d-expert-v2
do
DEVICE=${CUDA_DEVICES[$i]}  # Assign CUDA device based on current index
  for LEARN in behavior
  do
    for SEED in 0 1 2 3 4
    do
      session_name="session_$session_count"
      
      # Set the environment variable and run the Python command in a tmux session
      tmux new-session -d -s "$session_name" "CUDA_VISIBLE_DEVICES=$DEVICE python train.py --env $ENV --learn $LEARN --seed $SEED"
      
      session_count=$((session_count + 1))
    done

    # Increment index and reset if it exceeds the number of available devices
  done
  i=$((i + 1))
    if [ $i -ge ${#CUDA_DEVICES[@]} ]; then
      i=0
    fi
done


# for ENV in hopper-expert-v2
# do
#   for LEARN in brac naive-behavior naive-behavior-ppo  
#   do
#     for SEED in 0 1 2 3 4
#     do
#       session_name="session_$session_count"
      
#       # Correctly set the environment variable and run the Python command in a tmux session
#       tmux new-session -d -s "$session_name" "CUDA_VISIBLE_DEVICES=2 python train.py --env $ENV --learn $LEARN --seed $SEED"
      
#       session_count=$((session_count + 1))
#     done
#   done
# done





