import os
import numpy as np
import numpy.linalg as la

n_col = 5
# added_path = 'data/da_10906555'
added_path = 'data/ace2'
#coords [frames, atoms, coordinates]
data_signal = [[], [], []]
edge_signal = []
data_labels = []

rootdir = os.getcwd()
list_dirs = os.listdir(os.path.join(rootdir, added_path))
list_dirs = [x for x in list_dirs if x.startswith('DESRES') and x.endswith('CA')]
#print(list_dirs)
list_dirs = sorted(list_dirs)
print('Number of simulations', len(list_dirs))
for idx, subdir in enumerate(list_dirs):
        print('Directory', subdir)
        filename = os.path.join(rootdir, added_path, subdir, 'equilibrium.txt')
        fp = open(filename, 'r')
        frame = []
        for idx2, line in enumerate(fp):
                if idx2 == 0:
                    dummy = 1
                elif (idx2 == 1):
                    if idx == 0:
                        signal = line.rstrip()
                        signal = [x for x in signal.split()]
                        bond_idx0 = np.asarray(signal, dtype=np.int)
                elif (idx2 == 2):
                    if idx == 0:
                        signal = line.rstrip()
                        signal = [x for x in signal.split()]
                        bond_idx1 = np.asarray(signal, dtype=np.int)
                elif (idx2 -3) % n_col != 0:
                        signal = line.rstrip()
                        signal = [float(x) for x in signal.split()]
                        if ((idx2 -3) % n_col) - 1 == 0:
                            edge_signal += [signal]
                        else:
                            #print('signal size', np.array(signal).shape)
                            data_signal[((idx2 - 3) % n_col) - 2] += [np.array(signal, dtype=np.float32)]
                if (idx2 - 3) % n_col == 0:
                        data_labels += [idx]
        fp.close()
data = np.asarray(data_signal, dtype=np.float32)
edge = np.asarray(edge_signal, dtype=np.float32)
print('data signal size', data.shape)
print('edge signal size', edge.shape)
data = np.swapaxes(data, 0, 1)
edge_length = np.expand_dims(edge, 1)
labels = np.asarray(data_labels)

edge_normal = np.zeros([edge_length.shape[0], 3, edge_length.shape[-1]])
#Compute nromal information
print('Edge normal shape', edge_normal.shape)
#for idx in range(edge_normal.shape[-1]):
#    bond_type = idx % 8
#    bond_num = idx // 8
#    if bond_type < 2:
#        vec = data[:, :, 4 * bond_num + 1] - data[:, :, 4* bond_num]
#        edge_normal[:, :, idx] = vec / la.norm(vec, axis=1, keepdims=True)
#    elif bond_type < 4:
#        vec = data[:, :, 4 * bond_num + 1] - data[:, :, 4* bond_num + 2]
#        edge_normal[:, :, idx] = vec / la.norm(vec, axis=1, keepdims=True)
#    else:
#        vec1 = data[:, :, 4 * bond_num + 3] - data[:, :, 4* bond_num + 2]
#        vec2 = data[:, :, 4 * bond_num + 4] - data[:, :, 4* bond_num + 2]
#        cross = np.cross(vec1, vec2)
#        edge_normal[:, :, idx] = cross / la.norm(cross, axis=1, keepdims=True)
edge_normal = data[:, :, bond_idx1] - data[:, :, bond_idx0]
edge_normal = edge_normal / la.norm(edge_normal, axis=1, keepdims=True)

print('Edge lengths', edge_length.shape)
print('Edge normals', edge_normal.shape)
print('Saving models')
print('Path', os.path.join(rootdir, added_path, 'equilibrium.npz'))
np.savez(os.path.join(rootdir, added_path, 'equilibrium.npz'), coord=data, edge_length=edge_length, edge_normal=edge_normal, bond_idx0=bond_idx0, bond_idx1=bond_idx1)
print('Done')
