import os
import numpy as np
import numpy.linalg as la

n_col = 5
# added_path = 'data/da_10906555'
# added_path = 'data/ace2'
added_path = 'data/sarscov2_closed'
# added_path = 'data/sarscov2_partialopen'
# added_path = 'data/protease'
#coords [frames, atoms, coordinates]
if added_path == 'data/da_10906555':
    n_frags = 9
    max_length = 198
    n_trajs = 50
    n_frames = 1668
elif added_path == 'data/ace2':
    n_frags = 1
    max_length = 597
    n_trajs = 75
    n_frames = 1668
elif added_path == 'data/sarscov2_closed' or added_path == 'data/sarscov2_partialopen':
    n_frags = 3
    max_length = 1121
    n_trajs = 1
    n_frames = 2001
elif added_path == 'data/protease':
    n_frags = 2
    max_length = 306
    n_trajs = 1
    n_frames = 10001
else:
    raise NameError('Error: Not a valid dataset.')
data_signal = np.zeros([n_trajs * n_frames, 3, max_length, n_frags])
#data_signal = np.zeros([50 * 1668, 3, 198, 9])
#data_signal = np.zeros([78 * 1668, 3, 597, 1])

rootdir = os.getcwd()
list_dirs = os.listdir(os.path.join(rootdir, added_path))
list_dirs = [x for x in list_dirs if x.endswith('CA')]
#print(list_dirs)
list_dirs = sorted(list_dirs)
mod_idx = 3 * n_frags
print('Number of simulations', len(list_dirs))
for idx, subdir in enumerate(list_dirs):
    print('Directory', subdir)
    filename = os.path.join(rootdir, added_path, subdir, 'data_CA.txt')
    fp = open(filename, 'r')
    frame = []
    for idx2, line in enumerate(fp):
        # each sub folder, meaning idx, has a n_frames, xyz, number of fragments
        frame_idx = (idx * n_frames * n_frags * 3 + idx2) // mod_idx
        coord_idx = idx2 % 3
        frag_idx = (idx2 // 3) % n_frags
        signal = line.rstrip()
        signal = [x for x in signal.split()]
        coord_signal = np.asarray(signal, dtype=np.float32)
        data_signal[frame_idx, coord_idx, :len(coord_signal), frag_idx] = coord_signal
    fp.close()
data_signal = np.array(data_signal, dtype=np.float32)
print('data signal size', data_signal.shape)
print('frame idx', frame_idx)

print('Saving models')
print('Path', os.path.join(rootdir, added_path, 'data_CA.npy'))
np.save(os.path.join(rootdir, added_path, 'data_CA.npy'), data_signal)
print('Done')
