GPUID=$1
OUTDIR=outputs/mlp2/split_MNIST
REPEAT=10
mkdir -p $OUTDIR

# INCREMENTAL TASK
python -u iBatchLearn.py --gpuid $GPUID --repeat $REPEAT --dataroot /shared/sets/datasets/vision --optimizer Adam    --force_out_dim 0 --first_split_size 2 --other_split_size 2 --schedule 4 --batch_size 128 --model_name MLP2                                              --lr 0.001 --offline_training  | tee ${OUTDIR}/IT_Offline.log
python -u iBatchLearn.py --gpuid $GPUID --repeat $REPEAT --dataroot /shared/sets/datasets/vision --optimizer Adam    --force_out_dim 0 --first_split_size 2 --other_split_size 2 --schedule 4 --batch_size 128 --model_name MLP2                                              --lr 0.001                     | tee ${OUTDIR}/IT_Adam.log
python -u iBatchLearn.py --gpuid $GPUID --repeat $REPEAT --dataroot /shared/sets/datasets/vision --optimizer SGD     --force_out_dim 0 --first_split_size 2 --other_split_size 2 --schedule 4 --batch_size 128 --model_name MLP2                                              --lr 0.01                      | tee ${OUTDIR}/IT_SGD.log
python -u iBatchLearn.py --gpuid $GPUID --repeat $REPEAT --dataroot /shared/sets/datasets/vision --optimizer Adagrad --force_out_dim 0 --first_split_size 2 --other_split_size 2 --schedule 4 --batch_size 128 --model_name MLP2                                              --lr 0.01                      | tee ${OUTDIR}/IT_Adagrad.log
python -u iBatchLearn.py --gpuid $GPUID --repeat $REPEAT --dataroot /shared/sets/datasets/vision --optimizer Adam    --force_out_dim 0 --first_split_size 2 --other_split_size 2 --schedule 4 --batch_size 128 --model_name MLP2 --agent_type customization  --agent_name EWC_online_mnist --lr 0.001 --reg_coef 400      | tee ${OUTDIR}/IT_EWC_online.log
python -u iBatchLearn.py --gpuid $GPUID --repeat $REPEAT --dataroot /shared/sets/datasets/vision --optimizer Adam    --force_out_dim 0 --first_split_size 2 --other_split_size 2 --schedule 4 --batch_size 128 --model_name MLP2 --agent_type customization  --agent_name EWC_mnist        --lr 0.001 --reg_coef 100      | tee ${OUTDIR}/IT_EWC.log
python -u iBatchLearn.py --gpuid $GPUID --repeat $REPEAT --dataroot /shared/sets/datasets/vision --optimizer Adam    --force_out_dim 0 --first_split_size 2 --other_split_size 2 --schedule 4 --batch_size 128 --model_name MLP2 --agent_type regularization --agent_name SI  --lr 0.001 --reg_coef 300      | tee ${OUTDIR}/IT_SI.log
python -u iBatchLearn.py --gpuid $GPUID --repeat $REPEAT --dataroot /shared/sets/datasets/vision --optimizer Adam    --force_out_dim 0 --first_split_size 2 --other_split_size 2 --schedule 4 --batch_size 128 --model_name MLP2 --agent_type regularization --agent_name L2  --lr 0.001 --reg_coef 0.01      | tee ${OUTDIR}/IT_L2.log
python -u iBatchLearn.py --gpuid $GPUID --repeat $REPEAT --dataroot /shared/sets/datasets/vision --optimizer Adam    --force_out_dim 0 --first_split_size 2 --other_split_size 2 --schedule 4 --batch_size 128 --model_name MLP2 --agent_type regularization --agent_name MAS --lr 0.001 --reg_coef 1        | tee ${OUTDIR}/IT_MAS.log


# INCREMENTAL DOMAIN
python -u iBatchLearn.py --gpuid $GPUID --repeat $REPEAT --dataroot /shared/sets/datasets/vision --optimizer Adam    --force_out_dim 2 --first_split_size 2 --other_split_size 2 --schedule 4 --batch_size 128 --model_name MLP2                                              --lr 0.001 --offline_training  | tee ${OUTDIR}/ID_Offline.log
python -u iBatchLearn.py --gpuid $GPUID --repeat $REPEAT --dataroot /shared/sets/datasets/vision --optimizer Adam    --force_out_dim 2 --first_split_size 2 --other_split_size 2 --schedule 4 --batch_size 128 --model_name MLP2                                              --lr 0.001                     | tee ${OUTDIR}/ID_Adam.log
python -u iBatchLearn.py --gpuid $GPUID --repeat $REPEAT --dataroot /shared/sets/datasets/vision --optimizer SGD     --force_out_dim 2 --first_split_size 2 --other_split_size 2 --schedule 4 --batch_size 128 --model_name MLP2                                              --lr 0.01                      | tee ${OUTDIR}/ID_SGD.log
python -u iBatchLearn.py --gpuid $GPUID --repeat $REPEAT --dataroot /shared/sets/datasets/vision --optimizer Adagrad --force_out_dim 2 --first_split_size 2 --other_split_size 2 --schedule 4 --batch_size 128 --model_name MLP2                                              --lr 0.01                      | tee ${OUTDIR}/ID_Adagrad.log
python -u iBatchLearn.py --gpuid $GPUID --repeat $REPEAT --dataroot /shared/sets/datasets/vision --optimizer Adam    --force_out_dim 2 --first_split_size 2 --other_split_size 2 --schedule 4 --batch_size 128 --model_name MLP2 --agent_type customization  --agent_name EWC_online_mnist --lr 0.001 --reg_coef 700    | tee ${OUTDIR}/ID_EWC_online.log
python -u iBatchLearn.py --gpuid $GPUID --repeat $REPEAT --dataroot /shared/sets/datasets/vision --optimizer Adam    --force_out_dim 2 --first_split_size 2 --other_split_size 2 --schedule 4 --batch_size 128 --model_name MLP2 --agent_type customization  --agent_name EWC_mnist        --lr 0.001 --reg_coef 100    | tee ${OUTDIR}/ID_EWC.log
python -u iBatchLearn.py --gpuid $GPUID --repeat $REPEAT --dataroot /shared/sets/datasets/vision --optimizer Adam    --force_out_dim 2 --first_split_size 2 --other_split_size 2 --schedule 4 --batch_size 128 --model_name MLP2 --agent_type regularization --agent_name SI  --lr 0.001 --reg_coef 3000     | tee ${OUTDIR}/ID_SI.log
python -u iBatchLearn.py --gpuid $GPUID --repeat $REPEAT --dataroot /shared/sets/datasets/vision --optimizer Adam    --force_out_dim 2 --first_split_size 2 --other_split_size 2 --schedule 4 --batch_size 128 --model_name MLP2 --agent_type regularization --agent_name L2  --lr 0.001 --reg_coef 0.5      | tee ${OUTDIR}/ID_L2.log
python -u iBatchLearn.py --gpuid $GPUID --repeat $REPEAT --dataroot /shared/sets/datasets/vision --optimizer Adam    --force_out_dim 2 --first_split_size 2 --other_split_size 2 --schedule 4 --batch_size 128 --model_name MLP2 --agent_type regularization --agent_name MAS --lr 0.001 --reg_coef 10000    | tee ${OUTDIR}/ID_MAS.log


# INCREMENTAL CLASS
python -u iBatchLearn.py --gpuid $GPUID --repeat $REPEAT --dataroot /shared/sets/datasets/vision --incremental_class --optimizer Adam    --force_out_dim 10 --no_class_remap --first_split_size 2 --other_split_size 2 --schedule 4 --batch_size 128 --model_name MLP2                                              --lr 0.001 --offline_training  | tee ${OUTDIR}/IC_Offline.log
python -u iBatchLearn.py --gpuid $GPUID --repeat $REPEAT --dataroot /shared/sets/datasets/vision --incremental_class --optimizer Adam    --force_out_dim 10 --no_class_remap --first_split_size 2 --other_split_size 2 --schedule 4 --batch_size 128 --model_name MLP2                                              --lr 0.001                     | tee ${OUTDIR}/IC_Adam.log
python -u iBatchLearn.py --gpuid $GPUID --repeat $REPEAT --dataroot /shared/sets/datasets/vision --incremental_class --optimizer SGD     --force_out_dim 10 --no_class_remap --first_split_size 2 --other_split_size 2 --schedule 4 --batch_size 128 --model_name MLP2                                              --lr 0.01                      | tee ${OUTDIR}/IC_SGD.log
python -u iBatchLearn.py --gpuid $GPUID --repeat $REPEAT --dataroot /shared/sets/datasets/vision --incremental_class --optimizer Adagrad --force_out_dim 10 --no_class_remap --first_split_size 2 --other_split_size 2 --schedule 4 --batch_size 128 --model_name MLP2                                              --lr 0.01                      | tee ${OUTDIR}/IC_Adagrad.log
python -u iBatchLearn.py --gpuid $GPUID --repeat $REPEAT --dataroot /shared/sets/datasets/vision --incremental_class --optimizer Adam    --force_out_dim 10 --no_class_remap --first_split_size 2 --other_split_size 2 --schedule 4 --batch_size 128 --model_name MLP2 --agent_type customization  --agent_name EWC_mnist        --lr 0.001 --reg_coef 600      | tee ${OUTDIR}/IC_EWC.log
python -u iBatchLearn.py --gpuid $GPUID --repeat $REPEAT --dataroot /shared/sets/datasets/vision --incremental_class --optimizer Adam    --force_out_dim 10 --no_class_remap --first_split_size 2 --other_split_size 2 --schedule 4 --batch_size 128 --model_name MLP2 --agent_type customization  --agent_name EWC_online_mnist --lr 0.001 --reg_coef 100      | tee ${OUTDIR}/IC_EWC_online.log
python -u iBatchLearn.py --gpuid $GPUID --repeat $REPEAT --dataroot /shared/sets/datasets/vision --incremental_class --optimizer Adam    --force_out_dim 10 --no_class_remap --first_split_size 2 --other_split_size 2 --schedule 4 --batch_size 128 --model_name MLP2 --agent_type regularization --agent_name SI  --lr 0.001 --reg_coef 600      | tee ${OUTDIR}/IC_SI.log
python -u iBatchLearn.py --gpuid $GPUID --repeat $REPEAT --dataroot /shared/sets/datasets/vision --incremental_class --optimizer Adam    --force_out_dim 10 --no_class_remap --first_split_size 2 --other_split_size 2 --schedule 4 --batch_size 128 --model_name MLP2 --agent_type regularization --agent_name L2  --lr 0.001 --reg_coef 100      | tee ${OUTDIR}/IC_L2.log
python -u iBatchLearn.py --gpuid $GPUID --repeat $REPEAT --dataroot /shared/sets/datasets/vision --incremental_class --optimizer Adam    --force_out_dim 10 --no_class_remap --first_split_size 2 --other_split_size 2 --schedule 4 --batch_size 128 --model_name MLP2 --agent_type regularization --agent_name MAS --lr 0.001 --reg_coef 1        |tee  ${OUTDIR}/IC_MAS.log
