DOMAINS = [
    'walker',
    'quadruped',
    'jaco',
]

WALKER_TASKS = [
    'walker_stand',
    'walker_walk',
    'walker_run',
    'walker_flip',
]

QUADRUPED_TASKS = [
    'quadruped_walk',
    'quadruped_run',
    'quadruped_stand',
    'quadruped_jump',
]

JACO_TASKS = [
    'jaco_reach_top_left',
    'jaco_reach_top_right',
    'jaco_reach_bottom_left',
    'jaco_reach_bottom_right',
]

TASKS = WALKER_TASKS + QUADRUPED_TASKS + JACO_TASKS

parameter_1 = ['0.4', '0.8', '1.0', '1.4']
parameter_1_eval = ['0.6', '1.2']

parameter_2 = ['0.2', '0.6', '1.0', '1.4', '1.8']
parameter_2_eval = ['0.4', '0.8', '1.2', '1.6']

parameter_3 = ['0.75', '0.85', '1.0', '1.15', '1.25']
parameter_3_eval = ['0.40', '0.50', '1.50', '1.60']

parameter_4 = ['0.6', '0.8', '1.0', '1.2', '1.4']
parameter_4_eval = ['0.4', '0.5', '1.6', '1.7']

parameter_5 = ['0.2', '0.5', '1.0', '2.0', '4.0']
parameter_5_eval = ['0.4', '0.8', '1.5', '3.0']

PRETRAIN_TASKS = {
    'walker': 'walker_stand',
    'jaco': 'jaco_reach_top_left',
    'quadruped': 'quadruped_walk',
    'walker_mass': ['walker_stand~mass~' + para for para in parameter_1],
    'walker_mass2': ['walker_stand~mass~' + para for para in parameter_2],

    'walker2_mass': ['walker_stand~mass2~' + para for para in parameter_1],
    'walker2_mass2': ['walker_stand~mass2~' + para for para in parameter_2],

    'walker_damping': ['walker_stand~damping~' + para for para in parameter_3],
    'walker_damping2': ['walker_stand~damping~' + para for para in parameter_4],
    'walker_damping3': ['walker_stand~damping~' + para for para in parameter_2],
    'walker_damping4': ['walker_stand~damping~' + para for para in parameter_5],

    'cheetah_mass': ['cheetah_run~mass~' + para for para in parameter_1],
    'cheetah_mass2': ['cheetah_run~mass~' + para for para in parameter_2],

    'cheetah2_mass': ['cheetah_run~mass2~' + para for para in parameter_1],
    'cheetah2_mass2': ['cheetah_run~mass2~' + para for para in parameter_2],

    'cheetah_damping': ['cheetah_run~damping~' + para for para in parameter_3],

    'quadruped_mass': ['quadruped_stand~mass~' + para for para in parameter_1],
    'quadruped_mass2': ['quadruped_stand~mass~' + para for para in parameter_2],

    'quadruped2_mass': ['quadruped_stand~mass2~' + para for para in parameter_1],
    'quadruped2_mass2': ['quadruped_stand~mass2~' + para for para in parameter_2],

    'quadruped_damping': ['quadruped_stand~damping~' + para for para in parameter_3],
    'quadruped_damping3': ['quadruped_stand~damping~' + para for para in parameter_2],
    'quadruped_damping4': ['quadruped_stand~damping~' + para for para in parameter_5],

    'jaco_mass': ['jaco_reach_top_left~mass~' + para for para in parameter_1],
    'jaco_mass2': ['jaco_reach_top_left~mass~' + para for para in parameter_2],

    'jaco2_mass': ['jaco_reach_top_left~mass2~' + para for para in parameter_1],
    'jaco2_mass2': ['jaco_reach_top_left~mass2~' + para for para in parameter_2],

    'jaco_damping': ['jaco_reach_top_left~damping~' + para for para in parameter_3],
}

FINETUNE_TASKS = {
    'walker_stand_mass': ['walker_stand~mass~' + para for para in parameter_1],
    'walker_stand_mass_eval': ['walker_stand~mass~' + para for para in parameter_1_eval],
    'walker_walk_mass': ['walker_walk~mass~' + para for para in parameter_1],
    'walker_walk_mass_eval': ['walker_walk~mass~' + para for para in parameter_1_eval],
    'walker_run_mass': ['walker_run~mass~' + para for para in parameter_1],
    'walker_run_mass_eval': ['walker_run~mass~' + para for para in parameter_1_eval],
    'walker_flip_mass': ['walker_flip~mass~' + para for para in parameter_1],
    'walker_flip_mass_eval': ['walker_flip~mass~' + para for para in parameter_1_eval],

    'walker_stand_mass2': ['walker_stand~mass~' + para for para in parameter_2],
    'walker_stand_mass2_eval': ['walker_stand~mass~' + para for para in parameter_2_eval],
    'walker_walk_mass2': ['walker_walk~mass~' + para for para in parameter_2],
    'walker_walk_mass2_eval': ['walker_walk~mass~' + para for para in parameter_2_eval],
    'walker_run_mass2': ['walker_run~mass~' + para for para in parameter_2],
    'walker_run_mass2_eval': ['walker_run~mass~' + para for para in parameter_2_eval],
    'walker_flip_mass2': ['walker_flip~mass~' + para for para in parameter_2],
    'walker_flip_mass2_eval': ['walker_flip~mass~' + para for para in parameter_2_eval],

    'walker2_stand_mass': ['walker_stand~mass2~' + para for para in parameter_1],
    'walker2_stand_mass_eval': ['walker_stand~mass2~' + para for para in parameter_1_eval],
    'walker2_walk_mass': ['walker_walk~mass2~' + para for para in parameter_1],
    'walker2_walk_mass_eval': ['walker_walk~mass2~' + para for para in parameter_1_eval],
    'walker2_run_mass': ['walker_run~mass2~' + para for para in parameter_1],
    'walker2_run_mass_eval': ['walker_run~mass2~' + para for para in parameter_1_eval],
    'walker2_flip_mass': ['walker_flip~mass2~' + para for para in parameter_1],
    'walker2_flip_mass_eval': ['walker_flip~mass2~' + para for para in parameter_1_eval],

    'walker2_stand_mass2': ['walker_stand~mass2~' + para for para in parameter_2],
    'walker2_stand_mass2_eval': ['walker_stand~mass2~' + para for para in parameter_2_eval],
    'walker2_walk_mass2': ['walker_walk~mass2~' + para for para in parameter_2],
    'walker2_walk_mass2_eval': ['walker_walk~mass2~' + para for para in parameter_2_eval],
    'walker2_run_mass2': ['walker_run~mass2~' + para for para in parameter_2],
    'walker2_run_mass2_eval': ['walker_run~mass2~' + para for para in parameter_2_eval],
    'walker2_flip_mass2': ['walker_flip~mass2~' + para for para in parameter_2],
    'walker2_flip_mass2_eval': ['walker_flip~mass2~' + para for para in parameter_2_eval],

    'walker_stand_damping': ['walker_stand~damping~' + para for para in parameter_3],
    'walker_stand_damping_eval': ['walker_stand~damping~' + para for para in parameter_3_eval],
    'walker_walk_damping': ['walker_walk~damping~' + para for para in parameter_3],
    'walker_walk_damping_eval': ['walker_walk~damping~' + para for para in parameter_3_eval],
    'walker_run_damping': ['walker_run~damping~' + para for para in parameter_3],
    'walker_run_damping_eval': ['walker_run~damping~' + para for para in parameter_3_eval],
    'walker_flip_damping': ['walker_flip~damping~' + para for para in parameter_3],
    'walker_flip_damping_eval': ['walker_flip~damping~' + para for para in parameter_3_eval],

    'walker_stand_damping2': ['walker_stand~damping~' + para for para in parameter_4],
    'walker_stand_damping2_eval': ['walker_stand~damping~' + para for para in parameter_4_eval],
    'walker_walk_damping2': ['walker_walk~damping~' + para for para in parameter_4],
    'walker_walk_damping2_eval': ['walker_walk~damping~' + para for para in parameter_4_eval],
    'walker_run_damping2': ['walker_run~damping~' + para for para in parameter_4],
    'walker_run_damping2_eval': ['walker_run~damping~' + para for para in parameter_4_eval],
    'walker_flip_damping2': ['walker_flip~damping~' + para for para in parameter_4],
    'walker_flip_damping2_eval': ['walker_flip~damping~' + para for para in parameter_4_eval],

    'walker_stand_damping3': ['walker_stand~damping~' + para for para in parameter_2],
    'walker_stand_damping3_eval': ['walker_stand~damping~' + para for para in parameter_2_eval],
    'walker_walk_damping3': ['walker_walk~damping~' + para for para in parameter_2],
    'walker_walk_damping3_eval': ['walker_walk~damping~' + para for para in parameter_2_eval],
    'walker_run_damping3': ['walker_run~damping~' + para for para in parameter_2],
    'walker_run_damping3_eval': ['walker_run~damping~' + para for para in parameter_2_eval],
    'walker_flip_damping3': ['walker_flip~damping~' + para for para in parameter_2],
    'walker_flip_damping3_eval': ['walker_flip~damping~' + para for para in parameter_2_eval],

    'walker_stand_damping4': ['walker_stand~damping~' + para for para in parameter_5],
    'walker_stand_damping4_eval': ['walker_stand~damping~' + para for para in parameter_5_eval],
    'walker_walk_damping4': ['walker_walk~damping~' + para for para in parameter_5],
    'walker_walk_damping4_eval': ['walker_walk~damping~' + para for para in parameter_5_eval],
    'walker_run_damping4': ['walker_run~damping~' + para for para in parameter_5],
    'walker_run_damping4_eval': ['walker_run~damping~' + para for para in parameter_5_eval],
    'walker_flip_damping4': ['walker_flip~damping~' + para for para in parameter_5],
    'walker_flip_damping4_eval': ['walker_flip~damping~' + para for para in parameter_5_eval],

    'cheetah_run_mass': ['cheetah_run~mass~' + para for para in parameter_1],
    'cheetah_run_mass_eval': ['cheetah_run~mass~' + para for para in parameter_1_eval],
    'cheetah_run_backward_mass': ['cheetah_run_backward~mass~' + para for para in parameter_1],
    'cheetah_run_backward_mass_eval': ['cheetah_run_backward~mass~' + para for para in parameter_1_eval],
    'cheetah_flip_mass': ['cheetah_flip~mass~' + para for para in parameter_1],
    'cheetah_flip_mass_eval': ['cheetah_flip~mass~' + para for para in parameter_1_eval],
    'cheetah_flip_backward_mass': ['cheetah_flip_backward~mass~' + para for para in parameter_1],
    'cheetah_flip_backward_mass_eval': ['cheetah_flip_backward~mass~' + para for para in parameter_1_eval],

    'cheetah_run_mass2': ['cheetah_run~mass~' + para for para in parameter_2],
    'cheetah_run_mass2_eval': ['cheetah_run~mass~' + para for para in parameter_2_eval],
    'cheetah_run_backward_mass2': ['cheetah_run_backward~mass~' + para for para in parameter_2],
    'cheetah_run_backward_mass2_eval': ['cheetah_run_backward~mass~' + para for para in parameter_2_eval],
    'cheetah_flip_mass2': ['cheetah_flip~mass~' + para for para in parameter_2],
    'cheetah_flip_mass2_eval': ['cheetah_flip~mass~' + para for para in parameter_2_eval],
    'cheetah_flip_backward_mass2': ['cheetah_flip_backward~mass~' + para for para in parameter_2],
    'cheetah_flip_backward_mass2_eval': ['cheetah_flip_backward~mass~' + para for para in parameter_2_eval],

    'cheetah2_run_mass': ['cheetah_run~mass2~' + para for para in parameter_1],
    'cheetah2_run_mass_eval': ['cheetah_run~mass2~' + para for para in parameter_1_eval],
    'cheetah2_run_backward_mass': ['cheetah_run_backward~mass2~' + para for para in parameter_1],
    'cheetah2_run_backward_mass_eval': ['cheetah_run_backward~mass2~' + para for para in parameter_1_eval],
    'cheetah2_flip_mass': ['cheetah_flip~mass2~' + para for para in parameter_1],
    'cheetah2_flip_mass_eval': ['cheetah_flip~mass2~' + para for para in parameter_1_eval],
    'cheetah2_flip_backward_mass': ['cheetah_flip_backward~mass2~' + para for para in parameter_1],
    'cheetah2_flip_backward_mass_eval': ['cheetah_flip_backward~mass2~' + para for para in parameter_1_eval],

    'cheetah2_run_mass2': ['cheetah_run~mass2~' + para for para in parameter_2],
    'cheetah2_run_mass2_eval': ['cheetah_run~mass2~' + para for para in parameter_2_eval],
    'cheetah2_run_backward_mass2': ['cheetah_run_backward~mass2~' + para for para in parameter_2],
    'cheetah2_run_backward_mass2_eval': ['cheetah_run_backward~mass2~' + para for para in parameter_2_eval],
    'cheetah2_flip_mass2': ['cheetah_flip~mass2~' + para for para in parameter_2],
    'cheetah2_flip_mass2_eval': ['cheetah_flip~mass2~' + para for para in parameter_2_eval],
    'cheetah2_flip_backward_mass2': ['cheetah_flip_backward~mass2~' + para for para in parameter_2],
    'cheetah2_flip_backward_mass2_eval': ['cheetah_flip_backward~mass2~' + para for para in parameter_2_eval],

    'cheetah_run_damping': ['cheetah_run~damping~' + para for para in parameter_3],
    'cheetah_run_damping_eval': ['cheetah_run~damping~' + para for para in parameter_3_eval],
    'cheetah_run_backward_damping': ['cheetah_run_backward~damping~' + para for para in parameter_3],
    'cheetah_run_backward_damping_eval': ['cheetah_run_backward~damping~' + para for para in parameter_3_eval],
    'cheetah_flip_damping': ['cheetah_flip~damping~' + para for para in parameter_3],
    'cheetah_flip_damping_eval': ['cheetah_flip~damping~' + para for para in parameter_3_eval],
    'cheetah_flip_backward_damping': ['cheetah_flip_backward~damping~' + para for para in parameter_3],
    'cheetah_flip_backward_damping_eval': ['cheetah_flip_backward~damping~' + para for para in parameter_3_eval],

    'quadruped_stand_mass': ['quadruped_stand~mass~' + para for para in parameter_1],
    'quadruped_stand_mass_eval': ['quadruped_stand~mass~' + para for para in parameter_1_eval],
    'quadruped_walk_mass': ['quadruped_walk~mass~' + para for para in parameter_1],
    'quadruped_walk_mass_eval': ['quadruped_walk~mass~' + para for para in parameter_1_eval],
    'quadruped_run_mass': ['quadruped_run~mass~' + para for para in parameter_1],
    'quadruped_run_mass_eval': ['quadruped_run~mass~' + para for para in parameter_1_eval],
    'quadruped_jump_mass': ['quadruped_jump~mass~' + para for para in parameter_1],
    'quadruped_jump_mass_eval': ['quadruped_jump~mass~' + para for para in parameter_1_eval],

    'quadruped_stand_mass2': ['quadruped_stand~mass~' + para for para in parameter_2],
    'quadruped_stand_mass2_eval': ['quadruped_stand~mass~' + para for para in parameter_2_eval],
    'quadruped_walk_mass2': ['quadruped_walk~mass~' + para for para in parameter_2],
    'quadruped_walk_mass2_eval': ['quadruped_walk~mass~' + para for para in parameter_2_eval],
    'quadruped_run_mass2': ['quadruped_run~mass~' + para for para in parameter_2],
    'quadruped_run_mass2_eval': ['quadruped_run~mass~' + para for para in parameter_2_eval],
    'quadruped_jump_mass2': ['quadruped_jump~mass~' + para for para in parameter_2],
    'quadruped_jump_mass2_eval': ['quadruped_jump~mass~' + para for para in parameter_2_eval],

    'quadruped2_stand_mass': ['quadruped_stand~mass2~' + para for para in parameter_1],
    'quadruped2_stand_mass_eval': ['quadruped_stand~mass2~' + para for para in parameter_1_eval],
    'quadruped2_walk_mass': ['quadruped_walk~mass2~' + para for para in parameter_1],
    'quadruped2_walk_mass_eval': ['quadruped_walk~mass2~' + para for para in parameter_1_eval],
    'quadruped2_run_mass': ['quadruped_run~mass2~' + para for para in parameter_1],
    'quadruped2_run_mass_eval': ['quadruped_run~mass2~' + para for para in parameter_1_eval],
    'quadruped2_jump_mass': ['quadruped_jump~mass2~' + para for para in parameter_1],
    'quadruped2_jump_mass_eval': ['quadruped_jump~mass2~' + para for para in parameter_1_eval],

    'quadruped2_stand_mass2': ['quadruped_stand~mass2~' + para for para in parameter_2],
    'quadruped2_stand_mass2_eval': ['quadruped_stand~mass2~' + para for para in parameter_2_eval],
    'quadruped2_walk_mass2': ['quadruped_walk~mass2~' + para for para in parameter_2],
    'quadruped2_walk_mass2_eval': ['quadruped_walk~mass2~' + para for para in parameter_2_eval],
    'quadruped2_run_mass2': ['quadruped_run~mass2~' + para for para in parameter_2],
    'quadruped2_run_mass2_eval': ['quadruped_run~mass2~' + para for para in parameter_2_eval],
    'quadruped2_jump_mass2': ['quadruped_jump~mass2~' + para for para in parameter_2],
    'quadruped2_jump_mass2_eval': ['quadruped_jump~mass2~' + para for para in parameter_2_eval],

    'quadruped_stand_damping': ['quadruped_stand~damping~' + para for para in parameter_3],
    'quadruped_stand_damping_eval': ['quadruped_stand~damping~' + para for para in parameter_3_eval],
    'quadruped_walk_damping': ['quadruped_walk~damping~' + para for para in parameter_3],
    'quadruped_walk_damping_eval': ['quadruped_walk~damping~' + para for para in parameter_3_eval],
    'quadruped_run_damping': ['quadruped_run~damping~' + para for para in parameter_3],
    'quadruped_run_damping_eval': ['quadruped_run~damping~' + para for para in parameter_3_eval],
    'quadruped_jump_damping': ['quadruped_jump~damping~' + para for para in parameter_3],
    'quadruped_jump_damping_eval': ['quadruped_jump~damping~' + para for para in parameter_3_eval],

    'quadruped_stand_damping3': ['quadruped_stand~damping~' + para for para in parameter_2],
    'quadruped_stand_damping3_eval': ['quadruped_stand~damping~' + para for para in parameter_2_eval],
    'quadruped_walk_damping3': ['quadruped_walk~damping~' + para for para in parameter_2],
    'quadruped_walk_damping3_eval': ['quadruped_walk~damping~' + para for para in parameter_2_eval],
    'quadruped_run_damping3': ['quadruped_run~damping~' + para for para in parameter_2],
    'quadruped_run_damping3_eval': ['quadruped_run~damping~' + para for para in parameter_2_eval],
    'quadruped_jump_damping3': ['quadruped_jump~damping~' + para for para in parameter_2],
    'quadruped_jump_damping3_eval': ['quadruped_jump~damping~' + para for para in parameter_2_eval],

    'quadruped_stand_damping4': ['quadruped_stand~damping~' + para for para in parameter_5],
    'quadruped_stand_damping4_eval': ['quadruped_stand~damping~' + para for para in parameter_5_eval],
    'quadruped_walk_damping4': ['quadruped_walk~damping~' + para for para in parameter_5],
    'quadruped_walk_damping4_eval': ['quadruped_walk~damping~' + para for para in parameter_5_eval],
    'quadruped_run_damping4': ['quadruped_run~damping~' + para for para in parameter_5],
    'quadruped_run_damping4_eval': ['quadruped_run~damping~' + para for para in parameter_5_eval],
    'quadruped_jump_damping4': ['quadruped_jump~damping~' + para for para in parameter_5],
    'quadruped_jump_damping4_eval': ['quadruped_jump~damping~' + para for para in parameter_5_eval],

    'jaco_tl_mass': ['jaco_reach_top_left~mass~' + para for para in parameter_1],
    'jaco_tl_mass_eval': ['jaco_reach_top_left~mass~' + para for para in parameter_1_eval],
    'jaco_tr_mass': ['jaco_reach_top_right~mass~' + para for para in parameter_1],
    'jaco_tr_mass_eval': ['jaco_reach_top_right~mass~' + para for para in parameter_1_eval],
    'jaco_bl_mass': ['jaco_reach_bottom_left~mass~' + para for para in parameter_1],
    'jaco_bl_mass_eval': ['jaco_reach_bottom_left~mass~' + para for para in parameter_1_eval],
    'jaco_br_mass': ['jaco_reach_bottom_right~mass~' + para for para in parameter_1],
    'jaco_br_mass_eval': ['jaco_reach_bottom_right~mass~' + para for para in parameter_1_eval],

    'jaco_tl_mass2': ['jaco_reach_top_left~mass~' + para for para in parameter_2],
    'jaco_tl_mass2_eval': ['jaco_reach_top_left~mass~' + para for para in parameter_2_eval],
    'jaco_tr_mass2': ['jaco_reach_top_right~mass~' + para for para in parameter_2],
    'jaco_tr_mass2_eval': ['jaco_reach_top_right~mass~' + para for para in parameter_2_eval],
    'jaco_bl_mass2': ['jaco_reach_bottom_left~mass~' + para for para in parameter_2],
    'jaco_bl_mass2_eval': ['jaco_reach_bottom_left~mass~' + para for para in parameter_2_eval],
    'jaco_br_mass2': ['jaco_reach_bottom_right~mass~' + para for para in parameter_2],
    'jaco_br_mass2_eval': ['jaco_reach_bottom_right~mass~' + para for para in parameter_2_eval],

    'jaco2_tl_mass': ['jaco_reach_top_left~mass2~' + para for para in parameter_1],
    'jaco2_tl_mass_eval': ['jaco_reach_top_left~mass2~' + para for para in parameter_1_eval],
    'jaco2_tr_mass': ['jaco_reach_top_right~mass2~' + para for para in parameter_1],
    'jaco2_tr_mass_eval': ['jaco_reach_top_right~mass2~' + para for para in parameter_1_eval],
    'jaco2_bl_mass': ['jaco_reach_bottom_left~mass2~' + para for para in parameter_1],
    'jaco2_bl_mass_eval': ['jaco_reach_bottom_left~mass2~' + para for para in parameter_1_eval],
    'jaco2_br_mass': ['jaco_reach_bottom_right~mass2~' + para for para in parameter_1],
    'jaco2_br_mass_eval': ['jaco_reach_bottom_right~mass2~' + para for para in parameter_1_eval],

    'jaco2_tl_mass2': ['jaco_reach_top_left~mass2~' + para for para in parameter_2],
    'jaco2_tl_mass2_eval': ['jaco_reach_top_left~mass2~' + para for para in parameter_2_eval],
    'jaco2_tr_mass2': ['jaco_reach_top_right~mass2~' + para for para in parameter_2],
    'jaco2_tr_mass2_eval': ['jaco_reach_top_right~mass2~' + para for para in parameter_2_eval],
    'jaco2_bl_mass2': ['jaco_reach_bottom_left~mass2~' + para for para in parameter_2],
    'jaco2_bl_mass2_eval': ['jaco_reach_bottom_left~mass2~' + para for para in parameter_2_eval],
    'jaco2_br_mass2': ['jaco_reach_bottom_right~mass2~' + para for para in parameter_2],
    'jaco2_br_mass2_eval': ['jaco_reach_bottom_right~mass2~' + para for para in parameter_2_eval],

    'jaco_tl_damping': ['jaco_reach_top_left~damping~' + para for para in parameter_3],
    'jaco_tl_damping_eval': ['jaco_reach_top_left~damping~' + para for para in parameter_3_eval],
    'jaco_tr_damping': ['jaco_reach_top_right~damping~' + para for para in parameter_3],
    'jaco_tr_damping_eval': ['jaco_reach_top_right~damping~' + para for para in parameter_3_eval],
    'jaco_bl_damping': ['jaco_reach_bottom_left~damping~' + para for para in parameter_3],
    'jaco_bl_damping_eval': ['jaco_reach_bottom_left~damping~' + para for para in parameter_3_eval],
    'jaco_br_damping': ['jaco_reach_bottom_right~damping~' + para for para in parameter_3],
    'jaco_br_damping_eval': ['jaco_reach_bottom_right~damping~' + para for para in parameter_3_eval],
}
