# NPSQ Integration with lm-eval-harness

This patch integrates **NPSQ (Normalized Probability Shift by the Question)** into the `lm_eval_harness` framework. Follow the steps below to apply the patch and evaluate models using NPSQ.

---

## Installation Steps

### 1. Clone the lm-eval-harness Repository

```bash
git clone https://github.com/EleutherAI/lm-eval-harness.git
cd lm-eval-harness
```

### 2. Apply the Patch

Use the provided `npsq.patch` file to integrate NPSQ into the framework:

```bash
git checkout 1980a1
git apply npsq.patch
```

### 3. Install the `lm_eval` package

```
pip install .
```

-----------------------

## Using ANMPI for Evaluation

In the `yaml` file, add `acc_asym_norm_mutual_info` to the `metric_list` as follows:

```bash
metric_list:
	- metric: acc_npsq
```

Then, you can see the results measured by `ANMPI` as follows: 

```
hf (pretrained=Qwen/Qwen2.5-0.5B-Instruct,trust_remote_code=True), gen_kwargs: (None), limit: None, num_fewshot: 0, batch_size: 1
|       Tasks       |Version|Filter|n-shot| Metric |Value |   |Stderr|
|-------------------|------:|------|-----:|--------|-----:|---|-----:|
|cloze_arc_challenge|      1|none  |     0|acc     |0.3148|±  |0.0136|
|                   |       |none  |     0|acc_norm|0.3490|±  |0.0139|
|                   |       |none  |     0|acc_npsq|0.3746|±  |0.0141|
```

