import numpy as np

class TabularMDP():

    def __init__(self, nS, nA, T):
        self.nS = nS
        self.nA = nA
        self.T = T
        self.t = 0
        self.P = np.zeros(shape=(nS * nA, nS))
        self.R = np.zeros(nS * nA)
        self.mu = np.zeros(nS)
        self.mu[0] = 1

    def setP(self, P):
        self.P = P

    def setR(self, R):
        self.R = R

    def setmu(self, mu):
        self.mu = mu

    def step(self, a):
        if self.t < self.T:
            probs = self.P[self.s * self.nA + a]
            ns = np.random.choice(range(self.nS), p=probs)
            r = self.R[self.s * self.nA + a]
            out = (self.t, self.s, a, ns, r)
            self.s = ns
            self.t = self.t + 1
        else:
            out = None
        return out

    def reset(self):
        self.t = 0
        self.s = np.random.choice(range(self.nS), p=self.mu)
        return self.s

    def seed(self, seed=None):
        np.random.seed(seed)