
# KnotGym

## Environments

```sh
uv venv --python 3.10.12   &&  source .venv/bin/activate
# the requirements file perhaps have more than needed
uv pip sync requirements/requirements-mj.txt
# alternatively the main dependencies
uv pip install cython mujoco numpy gymnasium opencv-python imageio
# install pyknotid dependency for computing gauss code, with chelpers
cd pyknotid && python setup.py build_ext --inplace  && cd ..
# install knotygm
cd knotgym && uv pip install -e . && cd ..

# sanity check
MUJOCO_GL=osmesa python -c "import numpy, mujoco, cv2, knotgym, pyknotid"
python -c "from pyknotid.spacecurves import chelpers" 
```

Please install dependencies for each benchmark individually according to their own instructions.
We provide one snapshot of the environment in requirements/ folder.

## Training

```sh
# PPO
MUJOCO_GL=osmesa WANDB_PROJECT=knots-dev-ppo
python train_sb3_ppo_v2.py -C.num_envs=32 -C.env_config.task_max_n_crossings=4 -C.env_config.task_max_n_states=20 -C.seed=0 -C.env_config.task=unknot

# DreamerV3
MUJOCO_GL=osmesa WANDB_PROJECT=knots-dev-dreamerv3x python baselines/embodied/dreamerv3/main.py --run.envs=32 --run.save_every=3600 --configs=knot,size12m --run.debug=False --env.knot.task_max_n_crossings=4 --seed=0 --task=knot_unknot

# TD-MPC2
MUJOCO_GL=osmesa WANDB_PROJECT=knots-dev-tdmpc python baselines/tdmpc2/tdmpc2/train.py num_envs=16 steps_per_update=4 eval_episodes=16 model_size=5 task=unknot task_max_n_states=20 seed=0 task_max_n_crossings=4
```

## Evaluations

```sh
# PPO
MUJOCO_GL=osmesa WANDB_MODE=disabled python train_sb3_ppo_v2.py -C.do_eval -C.num_eval_envs=16 -C.n_eval_episodes=128 -C.env_config.task_max_n_states=20 -C.seed=0 \   -C.env_config.task_max_n_crossings=4 -C.env_config.task=unknot  -C.load_from=/path/to/ckpt.zip

# DreamerV3
MUJOCO_GL=osmesa python baselines/embodied/dreamerv3/main.py --script=eval_only --run.eval_envs=16 --run.steps=6400 --run.from_checkpoint=/path/to/ckpt/  --configs=knot,size12m --env.knot.split=ea --task=knot_unknot --env.knot.task_max_n_crossings=2 --env.knot.task_max_n_states=20 --seed=0 --run.debug=False

# TD-MPC2
MUJOCO_GL=osmesa python baselines/tdmpc2/tdmpc2/evaluate.py enable_wandb=false num_envs=16 eval_episodes=128 task=unknot task_max_n_crossings=2 task_max_n_states=20 seed=0 checkpoint=/path/to/ckpt.pt

# Prompting
cd baselines/vlm
MUJOCO_GL=osmesa python agent.py --backend=gpt-4.1-nano --openai_api_key your_key --query_mode=one_shot --stateful_window=-1 --task=eq1  --task_max_n_crossings=2 --num_episodes 110 --num_workers 20 --deploy
```

## Mujoco interactive viewer

```sh
# on macos (you will probably need to change MUJOCO_GL for other platforms)
MUJOCO_GL=glfw mjpython mjc_interact.py --mjcf knotgym/knotgym/assets/unknot7_float.xml
```

## Plotting

Scripts and data are in the analysis/ folder.
