# KnotGym

A unique knot-based environment that challenges planning with world models.

Keywords: manipulation, deformable objects, knot theory, topology, world models, long-horizon planning, GPU-based simulation

Environments

* `Unknot-v0`

Notable features

* Compatible with Gym API
* Spectrum of puzzle difficulty

## Snippets

To install

```{shell}
cd knotgym
pip install -e .
```

To import an environment

```{py}
import gymnasium as gym
import knotgym  # noqa: F401

env = gym.make("knotgym/Unknot-v0")
```

To interact with the knot with drag and drop

```{sh}
python -m mujoco.viewer --mjcf=knotgym/assets/unknot7_float.xml
```
