# KL Divergence for MCMC, SyGuS Benchmarks
## Supplementary material

### Requirements
- Python 3.10+
- [Poetry](https://python-poetry.org/)
- CUDA enabled accelerator (Recommended)

### Setup
1. Create a Poetry virtual env and install dependencies
```
poetry shell
poetry install
```

2. Define a `secrets.json` file in the top-leve directory with HuggingFace API key in the following format:
```
{
    "HF_TOKEN": "your_token"
}
```
You must have access to `meta-llama/Llama-3.1-8B-Instruct`

### Getting started
1. To run Grammar Aligned MCMC Sampling on SyGuS benchmarks
```
python -m run_gad_tasks
```

2. To generate the plots shown in the paper
```
python -m plot_gad_tasks
```
