
# $1 gpuid
# $2 runid

# base method
data=pacs #(mnist/cifar10/pacs/officehome)
backbone=regnet #regnet_large, regnet 
pretrained=True
projection_dim=1024 #mnist:128/ cifar10:512, pacs=1024, officehome:512
epochs=200 #default:5/200
batchsize=64 #16

lr=1e-4 
lr_scheduler=cosine 
optimizer=sgd 
# Base Model Path
svroot=saved-model/prof/${data}/base_${backbone}_${pretrained}_${projection_dim}_run${2} 

python3 main_base.py --gpu $1 --data ${data} --epochs ${epochs} --nbatch 100 --lr ${lr} --batchsize ${batchsize} --svroot $svroot --backbone ${backbone} --pretrained ${pretrained} --projection_dim ${projection_dim} --lr_scheduler ${lr_scheduler} --optimizer ${optimizer}
python3 main_test.py --gpu $1 --modelpath $svroot/best.pkl --svpath $svroot/test.log --backbone ${backbone} --projection_dim ${projection_dim} --data ${data}


