The code for **Learning to ignore: Single Source Domain Generalization via Oracle Regularization**.

 
### 1. Dependencies

- All environment is saved in sdg.yaml, we recommend that users create a virtual environment with the yaml file for use of the code.
- The source code is adjusted for use in python 3.9

### 2. Datasets

- Download the dataset from [Google drive](https://drive.google.com/drive/folders/1mauP-TJSWBOLa4F4HTXBVzfmd59feMKO?usp=sharing).
- Place the dataset files under the path `./data/`.

### 3. Model Weights

#### Model weights for AlexNet
- WARNING. this model weight is not finetuned on the source domain of PACS. Hence it requires the pretraining process.
- Download the AlexNet model weights (alexnet_caffe.pth.tar) from [Google drive](https://drive.google.com/drive/folders/1mauP-TJSWBOLa4F4HTXBVzfmd59feMKO?usp=sharing).
- Place the model weight under the path `./network/pretrained/`.
- Before running the code, adjust Line 90 of the ./network/alex_net.py to match your setting.

#### Model weights for Oracle
- Download the folder containing the Oracle model weights from [Google drive](https://drive.google.com/drive/folders/1mauP-TJSWBOLa4F4HTXBVzfmd59feMKO?usp=sharing).
- Place the folder under the path `./saved-model/prof/{$data}/`.
- Please check the `./main_my_iter.py` file, Line 251-280. The path written in the code should correspond with the path you placed the model weight folder.
- Certainly, you may train your own oracle. 

### 4. Pretrain

- Before pretraining, please move the script files from `./scripts/` to the same directory as the README.md file.
- First, run the command `sh {$data}_base.sh 0 0`. The command will pretrain the model. Please check if the script file is using correct hyperparams. 
- For the Oracle, run the command `sh prof_base.sh 0 0`. The command will pretrain the oracle. Please check if the script file is using correct hyperparams. Note that we also provided pretrained weights of the oracle.

### 5. Train

- Before training, please move the script files from `./scripts/` to the same directory as the README.md file.
- Run the command `sh {$data}_prof.sh 0 0` to train the sDG model using PROF. Please check if the script file is using correct hyperparams. 
- Run the command `sh {$data}.sh 0 0`. to train the sDG model using MDAR. Please check if the script file is using correct hyperparams.
- FYI: sh {script-file-name}.sh a b; a= gpu_id, b= run_id (e.g. To use multiple GPUs: sh pacs_prof.sh 0,1,2,3 0)
- We recommend using multiple GPUs for PROF, as it utilizes multiple models (the oracle, task model).


### 6. Experiments

#### Digits Experiment
- Digit Experiment: MNIST -> MNIST,MNIST-M,USPS,SVHN,SYNDIGIT
- Available Models: Custom MNIST-net

#### Corrupted CIFAR-10 Experiment
- Image Experiment: CIFAR10 -> Corrupted CIFAR-10
- Available Models: WRN

#### PACS Experiment 
- PACS Experiment: P -> A,C,S
- Available Models: AlexNet

#### Office-Home Experiment
- Office-Home Experiment: Real World -> Art, Clipart, Product
- Available Models: Resnet18

### Reference
- Our code is built using the source code of PDEN (https://github.com/lileicv/PDEN). We thank the authors of PDEN. We record references in the top of each file.
