#Reference: https://github.com/lileicv/PDEN/
import torch
import torch.nn as nn
import torch.nn.functional as F
torch.autograd.set_detect_anomaly(True)

class ConvNet(nn.Module):
    ''' The network structure is consistent with the M-ADA method of cvpr2020
        https://github.com/joffery/M-ADA
     '''
    def __init__(self, projection_dim, imdim=3):
        super(ConvNet, self).__init__()

        self.conv1 = nn.Conv2d(imdim, 64, kernel_size=5, stride=1, padding=0)
        self.mp = nn.MaxPool2d(2)
        self.relu1 = nn.ReLU(inplace=False) #TODO- inplace=True
        self.conv2 = nn.Conv2d(64, 128, kernel_size=5, stride=1, padding=0)
        self.relu2 = nn.ReLU(inplace=False) #TODO- inplace=True
        self.fc1 = nn.Linear(128*5*5, 1024)
        self.relu3 = nn.ReLU(inplace=False) #TODO- inplace=True
        self.fc2 = nn.Linear(1024, 1024)
        self.relu4 = nn.ReLU(inplace=False) #TODO- inplace=True
        
        self.cls_head_src = nn.Linear(1024, 10) #nn.Linear(self.buffer_features,10)
        self.cls_head_tgt = nn.Linear(1024, 10) ##nn.Linear(self.buffer_features,10)
        self.pro_head = nn.Linear(1024, projection_dim) ##nn.Linear(self.buffer_features,projection_dim)
        
        #self.buffer_features= 3024
        #self.buffer_head = nn.Linear(1024,self.buffer_features)

    def forward(self, x, mode='test'):
        in_size = x.size(0)
        
        out1 = self.mp(self.relu1(self.conv1(x)))
        out2 = self.mp(self.relu2(self.conv2(out1)))
        out2 = out2.view(in_size, -1)
        out3 = self.relu3(self.fc1(out2))
        out4 = self.relu4(self.fc2(out3))
        
        #out4= self.buffer_head(out4)
        if mode == 'test':
            p = self.cls_head_src(out4)
            return p
        elif mode == 'train':
            p = self.cls_head_src(out4)
            z = self.pro_head(out4)
            z = F.normalize(z) #nonorm testing
            return p,z
        elif mode == 'prof':
            p = self.cls_head_src(out4)
            z = self.pro_head(out4)
            z = F.normalize(z) #nonorm testing
            h= out4
            #h = F.normalize(out4)
            return p,z,h, None
        
        
    
class ConvNetVis(nn.Module):
    ''' 
    For easy visualization, the feature extractor outputs 2-d features
    '''
    def __init__(self, imdim=3):
        super(ConvNetVis, self).__init__()

        self.conv1 = nn.Conv2d(imdim, 64, kernel_size=5, stride=1, padding=0)
        self.mp = nn.MaxPool2d(2)
        self.relu1 = nn.ReLU(inplace=False) #TODO- inplace=True
        self.conv2 = nn.Conv2d(64, 128, kernel_size=5, stride=1, padding=0)
        self.relu2 = nn.ReLU(inplace=False) #TODO- inplace=True
        self.fc1 = nn.Linear(128*5*5, 1024)
        self.relu3 = nn.ReLU(inplace=False) #TODO- inplace=True
        self.fc2 = nn.Linear(1024, 2)
        self.relu4 = nn.ReLU(inplace=False) #TODO- inplace=True
        
        self.cls_head_src = nn.Linear(2, 10)
        self.cls_head_tgt = nn.Linear(2, 10)
        self.pro_head = nn.Linear(2, 128)

    def forward(self, x, mode='test'):
        in_size = x.size(0)
        out1 = self.mp(self.relu1(self.conv1(x)))
        out2 = self.mp(self.relu2(self.conv2(out1)))
        out2 = out2.view(in_size, -1)
        out3 = self.relu3(self.fc1(out2))
        out4 = self.relu4(self.fc2(out3))
        
        if mode == 'test':
            p = self.cls_head_src(out4)
            return p
        elif mode == 'train':
            p = self.cls_head_src(out4)
            z = self.pro_head(out4)
            z = F.normalize(z)
            return p,z
        elif mode == 'p_f':
            p = self.cls_head_src(out4)
            return p, out4
        
        #elif mode == 'target':
        #    p = self.cls_head_tgt(out4)
        #    z = self.pro_head(out4)
        #    z = F.normalize(z)
        #    return p,z
    

