# Self-supervised regression learning using domain knowledge: Applications to improving self-supervised image denoising

## Data construction, low-dose simulation, and FBP reconstruction

Obtain The 2016 Low Dose CT Grand Challenge data from https://aapm.app.box.com/s/eaw4jddb53keg1bptavvvd1sf4x3pe9h/file/856956352254.
This data was collected from 10 patients and contained overall 2378 full-dose slices of size 512×512 and 3mm thickness.

Then use "fan_proj_data_maker_FBPrecon.m" to construct the training and test datasets for experiments in Noise2True and in the Noise2Self and Noise2Same setups, or use "fan_proj_data_maker_odd_even_FBPrecon.m" to construct the training and test datasets for experiments in the Noise2Inverse setup. 

The Matlab codes should be run with Michigan Image Reconstruction Toolbox (MIRT): http://web.eecs.umich.edu/~fessler/code/index.html. Note that this toolbox only supports Linux/Mac. Before running the provided Matlab codes, you just need to run "setup.m" in MIRT.


## Test using pre-trained models
If you would like to quickly reproduce the results with DnCNN in Table S.3 in our paper, you could contrust only the test data and test with our trained models.
- python test_Challenge_data.py


Table C : Averaged test RMSE (HU) comparisons from different learning methods with DnCNN in low-dose CT denoising.

Noise2True | Noise2Self | Proposed SSRL in Noise2Self setup| Noise2Inverse | Proposed SSRL in Noise2Inverse setup| Noise2Same | Proposed SSRL Noise2Same in setup
---- | ---- | ---- | ---- | ---- | ---- | ----
16.3  | 36.2 | 25.0 | 22.9 | 21.9 | 28.4| 26.0 


## Training
We will make training code publicly available on GitHub if the paper is accepted.

