# Self-supervised regression learning using domain knowledge: Applications to improving self-supervised image denoising

## Test using pre-trained models on Set 5 (Quickstart)
You could quickly reproduce the results with DnCNN in Table S.2 in our paper with our provided trained models and test data Set 5. 
-     python test_set5.py

Predicted output images are in "./predicted_outputs".
If you want to calculate ssim of predicted output images, run:
-     matlab ssim_calc.m


Table S.2 : Averaged test PSNR (dB) (first row) and SSIM (second row) comparisons with different learning methods in camera image denoising with Set 5.

Noise2True | Noise2Self | Proposed SSRL in Noise2Self setup| Neighbor2Neighbor | Proposed SSRL in Neighbor2Neighbor setup| Noise2Same | Proposed SSRL Noise2Same in setup
---- | ---- | ---- | ---- | ---- | ---- | ----
26.4 dB | 19.3 dB | 21.2 dB | 21.2 dB | 19.0 dB | 21.9 dB | 18.9 dB | 20.0 dB 
0.890 | 0.743 | 0.785 | 0.744 | 0.806 | 0.729 | 0.753


## Test using pre-trained models on BSD 300
Download BSD 300 data from https://www2.eecs.berkeley.edu/Research/Projects/CS/vision/bsds/. Move the downloaded BSD 300 data to "./data" folder, and run:
-     cd  data
      python noise_gen_bsd300.py

Generated noisy and clean images are in 'data/training_data/BSD300_test'.
Then change line 27 "total_dirname = "./data/Set5"" to line 28 "total_dirname = "./data/BSD300_test"", and run:
-     python test_set5.py


## Construct training data

Download ImageNet ILSVRC 2012 Val data from https://www.image-net.org/. Move the downloaded data to "./data" folder, and run:
-     cd  data
      python noise_gen.py

Generated noisy and clean images are in 'data/training_data/Imagenet_Noisy' and 'data/training_data/Imagenet_Clean', repectively.

## Training
We will make training code publicly available on GitHub if the paper is accepted.
