# AtomFlow: Generate Ligand-binding Proteins from SMILES

This file contains the steps to run AtomFlow.

## Environment

AtomFlow requires at least one cuda GPU to execute on, and uses `cuda:0` as the default device.

AtomFlow builds on top of PyTorch. We suggest first installing a CUDA-enabled PyTorch on a virtual environment (or conda environment) following the official tutorial: https://pytorch.org/get-started/locally/. Then you need to install all the requirements listed in `requirements.txt`, either with pip or other package manager. After installing pip dependencies, install OpenFold with `pip install git+https://github.com/aqlaboratory/openfold.git`.

We provide a patch for `Atom.py` of the Biopython package, to enable its support for atoms with more than one letter (eg. `Cl`). The original file is located at `path-to-your-python-site-packages/Bio/PDB/Atom.py`. Replace the original one with the file provided in this folder.

## Execution

AtomFlow is provided as a gradio app. Start it with `python app.py`, and follow the instruction in your shell to open a website and interact with it.
