from dataclasses import dataclass, field
from typing import Any

from hydra.core.config_store import ConfigStore
from omegaconf import MISSING


@dataclass
class SchedulerConfig:
    _target_: str = MISSING


@dataclass
class CosineAnnealingWarmRestartsConfig(SchedulerConfig):
    _target_: str = "torch.optim.lr_scheduler.CosineAnnealingWarmRestarts"
    optimizer: Any = MISSING
    T_0: int = 10
    T_mult: int = 1
    eta_min: float = 0
    last_epoch: int = -1


def register_scheduler_configs() -> None:
    cs = ConfigStore.instance()
    cs.store(
        group="scheduler_lib/scheduler",
        name="CosineAnnealingWarmRestarts",
        node=CosineAnnealingWarmRestartsConfig,
    )
