import os
import _tkinter
import matplotlib
matplotlib.rcParams['pdf.fonttype'] = 42
matplotlib.rcParams['ps.fonttype'] = 42
from matplotlib import pyplot as plt
import numpy as np



alg_names = ['Current', 'Average', 'Centralized', 'Independent']
colors = [u'#1f77b4', u'#ff7f0e', u'#d62728', u'#2ca02c', u'#9467bd', u'#8c564b', u'#e377c2', u'#7f7f7f', u'#bcbd22', u'#17becf']

TESTS = 20
prefix = 'markov1_'
plot_reward = True
if plot_reward:
    task = 'reward'
else:
    task = 'gap'



xrange = 5000

x = range(xrange)

fig, ax = plt.subplots()

immediate_r = [[] for _ in range(TESTS)]
cumsum_r = [[] for _ in range(TESTS)]
immediate_gap = [[] for _ in range(TESTS)]
cumsum_gap = [[] for _ in range(TESTS)]

for test_id in range(TESTS):
    file = open(prefix + str(test_id) + '.txt', 'r')
    lines = file.readlines()
    for j in range(xrange):
        items = lines[j].strip().split('\t')
        immediate_r[test_id].append(float(items[0]))
        cumsum_r[test_id].append(float(items[1]))
        immediate_gap[test_id].append(float(items[2]))
        cumsum_gap[test_id].append(float(items[3]))
    print(len(lines))
    file.close()

immediate_r = np.array(immediate_r)
cumsum_r = np.array(cumsum_r)
immediate_gap = np.array(immediate_gap)
cumsum_gap = np.array(cumsum_gap)

immediate_err = []
immediate_mean = []
cumsum_err = []
cumsum_mean = []

for j in range(xrange):
    if plot_reward:
        tmp  = immediate_r[:, j]
    else:
        tmp = immediate_gap[:, j]

    immediate_err.append(1.96 * np.std(tmp) / np.sqrt(len(tmp)))
    immediate_mean.append(np.mean(tmp))

    if plot_reward:
        tmp  = cumsum_r[:, j]
    else:
        tmp = cumsum_gap[:, j]
    
    cumsum_err.append(1.96 * np.std(tmp) / np.sqrt(len(tmp)))
    cumsum_mean.append(np.mean(tmp))

immediate_err = np.array(immediate_err)
immediate_mean = np.array(immediate_mean)
cumsum_err = np.array(cumsum_err)
cumsum_mean = np.array(cumsum_mean)


ax.plot(x, immediate_mean, color=colors[0], label=alg_names[0])
ax.fill_between(x, (immediate_mean - immediate_err), (immediate_mean + immediate_err), color=colors[0], alpha=.2)


ax.plot(x, cumsum_mean, color=colors[1], label=alg_names[1])
ax.fill_between(x, (cumsum_mean - cumsum_err), (cumsum_mean + cumsum_err), color=colors[1], alpha=.2)


if plot_reward:
    centr = [[] for _ in range(TESTS)]
    indep = [[] for _ in range(TESTS)]
    for test_id in range(TESTS):
        file = open(prefix + str(test_id) + 'centr.txt', 'r')
        lines = file.readlines()
        for j in range(xrange):
            centr[test_id].append(float(lines[j].strip()))
        file.close()
    
    for test_id in range(TESTS):
        file = open(prefix + str(test_id) + 'indep.txt', 'r')
        lines = file.readlines()
        for j in range(xrange):
            indep[test_id].append(float(lines[j].strip()))
        file.close()

    centr = np.array(centr)
    indep = np.array(indep)

    centr_err = []
    centr_mean = []
    indep_err = []
    indep_mean = []

    for j in range(xrange):
        tmp  = centr[:, j]
        centr_err.append(1.96 * np.std(tmp) / np.sqrt(len(tmp)))
        centr_mean.append(np.mean(tmp))

        tmp  = indep[:, j]
        indep_err.append(1.96 * np.std(tmp) / np.sqrt(len(tmp)))
        indep_mean.append(np.mean(tmp))

    centr_err = np.array(centr_err)
    centr_mean = np.array(centr_mean)
    indep_err = np.array(indep_err)
    indep_mean = np.array(indep_mean)

    ax.plot(x, centr_mean, color=colors[2], label=alg_names[2])
    ax.fill_between(x, (centr_mean - centr_err), (centr_mean + centr_err), color=colors[2], alpha=.2)
    ax.plot(x, indep_mean, color=colors[3], label=alg_names[3])
    ax.fill_between(x, (indep_mean - indep_err), (indep_mean + indep_err), color=colors[3], alpha=.2)


plt.xlabel('Iterations', fontsize='x-large')
if plot_reward:
    plt.ylabel('Reward', fontsize='x-large')
    ax.legend(loc='lower right', fontsize='x-large')
else:
    plt.ylabel('Equilibrium Gap', fontsize='x-large')
    ax.legend(loc='upper right', fontsize='x-large')
# plt.show()
plt.savefig(prefix + task + '.pdf')
