import hydra
from omegaconf import DictConfig, OmegaConf
#   dotenv.load_dotenv(".env")
import glob
from evaluate_designs import get_predictions

@hydra.main(version_base=None, config_path="../configs", config_name="evaluate_designs")
def run(cfg: DictConfig) -> None:
    csvfiles = []
    if cfg.path is not None:
        csvfiles = glob.glob(f'{cfg.path}/*.csv')

    if cfg.csvfile is not None:
        csvfiles.append(cfg.csvfile)

    if cfg.csvfiles is not None:
        filenames = cfg.csvfiles
        csvfiles += filenames

    assert len(csvfiles) > 0
    print(csvfiles)

    for csvfile in csvfiles:
        print(csvfile)
        print(cfg.seedfile)
        get_predictions(csvfile, cfg.seedfile , method=cfg.method, title=cfg.title,
                        single_chain_only=cfg.single_chain_only)


run()
