#!/bin/bash
#SBATCH --job-name=AEGT      # Job name (change "your_job_name" to a descriptive name)
#SBATCH --output=slurm_output/AEGTSkempipropen_%j.out   # Output file for STDOUT (%j will be replaced with the job ID)
#SBATCH --error=slurm_output/AEGTSkempipropen_%j.err     # Error file for STDERR (%j will be replaced with the job ID)
#SBATCH -p gpu2
#SBATCH -t 72:00:00
#SBATCH --cpus-per-task=12               # Number of CPU cores per task
#SBATCH --gres=gpu:1
#SBATCH --mem-per-gpu=80G
#SBATCH --array=0-3

source ~/.bashrc

mamba activate env

export WANDB_INSECURE_DISABLE_SSL=true
export HYDRA_FULL_ERROR=1

seed=0 #$(( SLURM_ARRAY_TASK_ID ))
i=$(( SLURM_ARRAY_TASK_ID ))
dim=256
lr=0.0001
ED=5
datasets=("paired_datasets/skempi_matched_th0.5-1.5_edth${ED}_prop${ED}_minprop6.5_testAbsabdab_7243_ED50.parquet")
dataset=${datasets[$i]}
dirnames=(trastuzumab)
dirname=${dirnames[$i]}
nvidia-smi
PATH_TO_REPO=
python3 $PATH_TO_REPO/training/train_propen.py \
	seed=${seed} \
	data=paired_skempi_ED${ED}_th3 \
	data.datapath_paired=${dataset}\
	data.edges=true \
	++setup.seed.seed=${seed} \
	enhancers=gt \
	enhancers.model.d_model=${dim} \
	enhancers.training.lr=${lr} \
	++paths.root_dir="models_skempiED${ED}_minprop6.5/${dirname}/" \
        ++logger.name="gt_skempiED${ED}_${dirname}" \
	++logger.group="gt" \
	++logger.tags=["GT"] \
	++logger.entity=your-wand-name
nvidia-smi


