import yaml 
import pandas as pd


def read_yaml(file_path):
    """
    Read a YAML file and return it as a dictionary.
    
    Parameters:
    file_path (str): The path to the YAML file.
    
    Returns:
    dict: The contents of the YAML file as a dictionary.
    """
    with open(file_path, 'r') as file:
        data = yaml.safe_load(file)
    return data


def lookup_target_sequence():
    ag_seq_path = "s3://prescient-data-dev/raw/affinity/target_sequences.csv"
    ag_seq_lookup = pd.read_csv(ag_seq_path, index_col="target")["target_seq"].to_dict()
    return ag_seq_lookup
