
## Saving and training networks

### 1. Finding best hyperparameters of a certain network
Run launch.py. Then, using best.py, find the best hyperparameter configuration (the one  with highest largest test accuracy).

### 2. Training and saving trained networks with different intialization given a spesific hyper-parameter configuration 
Run launch_single.py, launch_random.py

### 3. Saving random networks
Run launch_random.py

## Main files files
launch files submits sbatch command that calls python codes running the training or saving a model. 

**cifar_exec.slurm**
```
->is called by launch files. Submits sbatch command that calls train_cifar.py
```

**train_cifar.py**
```
->main python file that runs the training and saves (trained or random) the networks. Utilizes data_util.py in calling the data and train_util.py in training
```

## FSE -VGG

fse_vgg_x_fitting_y with x \in {random,trained}, y \in {over,under}.
```
x=trained => FSE applied with trained models, random models otherwise.
```
```
y=over.   => FSE(under fits over), FSE(over fits under) otherwise. 
```

To get the fse results, follow these steps:
**1.Run fse_vgg_random_fitting_over.slurm, fse_vgg_random_fitting_under.slurm, fse_vgg_trained_fitting_over.slurm, fse_vgg_trained_fitting_under.slurm**
```
->slurm scripts that calls the following .py file.
```

**2.Run fse.py**
```
->python file that applies FSE.
```

Note that there also exists "shuffled_fse.py" that implements the shuffled regression explained in the appendix.

## FSE -Resnet
Similar to FSE -VGG.


## Feature performance

**1.launch_linear_resnet.py, launch_linear_vgg.py**
```
->python launch file that call the script cifar_exec_linear.slurm that runs a python code
```
**2. cifar_exec_linear.slurm**
```
->is called by launch_linear_x.py. Submits sbatch command that calls linear_feature_training.py
```
**linear_feature_training.py**
```
->python file that applies the feature performance. To run it, saved trained or random models are needed.
```

