import os
import subprocess
import re
import numpy as np
import itertools
import pickle

curr_dir=os.getcwd()
config_dir=curr_dir+'/config'


SEED_tab=list(np.load(config_dir+"/seeds.npy"))
d_tab=list(np.load(config_dir+"/d.npy"))
p_tab=list(np.load(config_dir+"/p.npy"))
k_tab=list(np.load(config_dir+"/k.npy"))
neuron_tab=list(np.load(config_dir+"/neuron.npy"))
mtrain_tab=list(np.load(config_dir+"/mtrain.npy"))



#acc_tab = np.zeros( (len(SEED_tab), len(LBLf_tab), len(LBLp_tab),\
#                     len(list_arch), len(OPT_tab)) )

list_params=[SEED_tab, p_tab, neuron_tab]

list_params= list(itertools.product(*list_params))

d = {}  
d_optim = {}
d_loss = {}
for a in list_params: 

    q = tuple(a)  
    d[q]= []
    d_optim[q]= []
    d_loss[q]= []

print(d)

directory= os.getcwd()

for filename in os.listdir(directory):
     if filename.startswith("slurm"):  
         line = subprocess.check_output(['tail', '-10', filename])
         line=line.decode("utf-8")
         line=str(line)
         #print(line)
         flts=re.findall(r"[-+]?\d*\.\d+|\d+", line)
         #print(filename)
         #print(flts)
         #['0.503086519241333', '78.2', '0', '0.0', '0.1', '100', '0.0', '1', '300', '2', '600', '0.0007']
         #print(flts)



         
         train_loss=float(flts[1])
         acc_val=float(float(flts[0]))
         #print(filename)
         #print(train_loss)
         #print(acc_val)


         seed = int(flts[2])#int(re.search(r'Seed: (\d+)', line).group(1))
         p = int(flts[6]) #float(flts[4])
         neurons = int(flts[7])

         #print(filename)
         #LR = re.search(r'LR: (\d+)', line).group(1)
         LR = float(flts[8])
         #print(arch)
 
         OPT = re.search(r'Optimization algorithm: (\S+)', line).group(1)
         #print(OPT)
         k = [seed,p,neurons]#train_loss
         q = tuple(k)
         if q in d:
             d[q].append(acc_val)
             d_loss[q].append(train_loss)
             
         if "GD" in OPT:
            LR = float(flts[8])
            B = int(flts[9])
            M= float(flts[10])
            fst_ann=int(flts[12])
            snd_ann=int(flts[14])
            WD=float(flts[15])
            
            k_opt = [LR,B,M,fst_ann,snd_ann,WD]
        
         else:
            M= float(flts[5])
            fst_ann=int(flts[6])
            snd_ann=int(flts[7])
            WD=float(flts[8]) 
            k_opt = [LR,M,fst_ann,snd_ann,WD]
            
         
         q_opt = tuple(k_opt)
         if q in d:
             d_optim[q].append(q_opt)    
         #break

## Finding max over each config:
         
for key in d: 
    #if "(100000, 1000)" in key:
    #    continue    
    print(key)
    idx_max = np.argmax(d[key])
    
    print("empty")
    
    print("Train acc: {}".format(d_loss[key][idx_max]))
    print("Best Accuracy: {}%".format(d[key][idx_max]))
    cfg = list(key)
    print("Seed: {}".format(cfg[0]))
    print("#### patch: {}".format(cfg[1]))
    print("#### neurons: {}".format(cfg[2]))
          
    cfg_opt = list(d_optim[key][idx_max])
    print("LR: {}; B: {}; M: {}; 1st anneal: {}; 2nd anneal: {}; WD: {}".format(cfg_opt[0],\
    cfg_opt[1], cfg_opt[2], cfg_opt[3], cfg_opt[4],\
            cfg_opt[5])) 
    print("\n")
             


 
