from abc import ABC, abstractmethod


class AbstractAgent(ABC):
    """
    An abstract base class for all agents.

    All agents must implement the act method, which chooses an action based on the given state.
    """

    @abstractmethod
    def act(self, state):
        """
        Choose an action based on the given state.

        Args:
            state: The current state of the environment.

        Returns:
            The action chosen by the agent.
        """
        pass
