import numpy as np

from agents.base import AbstractAgent


class RandomAgent(AbstractAgent):
    """
    An agent that chooses a random action at each time step.
    """

    def __init__(
        self, state_dim: int, n_actions: int, continuous_actions: bool = False
    ):
        """
        Initialize the agent.

        Args:
            state_dim: The dimension of the state space.
            n_actions: The number of actions in the action space.
            continuous_actions: Whether the action space is continuous.
        """
        self.state_dim = state_dim
        self.n_actions = n_actions
        self.continuous_actions = continuous_actions

    def act(self, state):
        """
        Choose a random action.

        Args:
            state: The current state of the environment.

        Returns:
            The action chosen by the agent.
        """
        if self.continuous_actions:
            action = np.random.uniform(0, 1, self.n_actions)
            return action
        else:
            return np.random.randint(self.n_actions)
