# ****** Lending *******
# Lending: Observations to be used by the RL agent
LENDING_STATE_KEYS = ["credit_score", "group", "loans_repaid", "loans_defaulted"]
# Lending: Observations without the group
LENDING_STATE_WITHOUT_GROUP_KEY = [
    "credit_score",
    "loans_repaid",
    "loans_defaulted",
]
# Lending: Previous applicant's updated state
LENDING_PREV_APPLICANT_NEXT_STATE_KEY = ["prev_applicant_new_credit_score"]
# Lending: Group key
LENDING_GROUP_KEY = ["group"]
# Lending and College Admission: Distribution over the groups
GROUP_DISTRIBUTION = (0.5, 0.5)
# Lending: Likelihoods of credit score given group membership
CREDIT_SCORE_DISTRIBUTION = (
    (0.0, 0.0, 0.0, 0.2, 0.3, 0.3, 0.2),
    (0.2, 0.2, 0.3, 0.2, 0.1, 0.0, 0.0),
)
# Lending: Likelihoods of loan payment success based on credit score
LENDING_SUCCESS_PROB = (0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9)

# ******** College Admission ********
# College Admission: Observations to be used by the RL agent
COLLEGE_ADMISSION_STATE_KEYS = [
    "score",
    "group",
]
# College Admission: Observations without the group
COLLEGE_ADMISSION_STATE_WITHOUT_GROUP_KEY = ["score"]
# College Admission: Previous applicant's updated state
COLLEGE_PREV_APPLICANT_NEXT_STATE_KEY = ["prev_applicant_acceptance"]
# Collge Admission: Group key
COLLEGE_ADMISSION_GROUP_KEY = ["group"]
# Collge Admission: Mean of the score distribution for each group
SCORE_DISTRIBUTION_MEAN = (8, 5)
# Collge Admission: Standard deviation of the score distribution for each group
SCORE_DISTRIBUTION_STD = (1, 1)
# Collge Admission: Mean of the budget distribution for each group
BUDGET_DISTRIBUTION_MEAN = (4, 2)
# Collge Admission: Standard deviation of the budget distribution for each group
BUDGET_DISTRIBUTION_STD = (1, 1)
# College Admission: Max budget
MAX_BUDGET = 5
# Collge Admission: Success probability given the score
COLLEGE_SUCCESS_PROB = (0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9)
