"""
Helper objects to store parameters.

Code based on: 
https://github.com/google/ml-fairness-gym
"""

import attr
import numpy as np
from typing import List


@attr.s
class Params(object):
    """Simple mutable storage class for parameter variables."""

    asdict = attr.asdict


@attr.s
class CostMatrix(object):
    tp = attr.ib()  #  type: float
    fp = attr.ib()  #  type: float
    fn = attr.ib()  #  type: float
    tn = attr.ib()  #  type: float

    def as_array(self):
        return np.array([[self.tn, self.fp], [self.fn, self.tp]])


@attr.s
class MinMax(object):
    """Defines min, max param values."""

    min = attr.ib(default=0)  # type: float
    max = attr.ib(default=1)  # type : float


@attr.s
class PosNeg(object):
    """Defines positive, negative change param values."""

    pos = attr.ib()  # type: float
    neg = attr.ib()  # type : float


@attr.s
class GMM(object):
    """Defines GMM Params."""

    mix_weight = attr.ib()  # type: List[float]
    mu = attr.ib()  # type : List[float]
    sigma = attr.ib()  # type : List[float]


@attr.s
class BoundedGaussian(object):
    """Defines Gaussian Params with min max bounds."""

    mu = attr.ib()  # type : float
    sigma = attr.ib()  # type : float
    min = attr.ib()  # type : float
    max = attr.ib()  # type : float
