import torch.nn as nn
import torch.nn.functional as F
import torch


class Linear(nn.Module):
    def __init__(self, n_classes, n_channels):
        super().__init__()
        self.fc = nn.Linear(n_channels*32*32, n_classes)

    def forward(self, x):
        x = x.view(x.size(0), -1)
        x = self.fc(x)
        return x


class FC(nn.Module):
    def __init__(self, n_classes, n_channels):
        super().__init__()
        self.fc1 = nn.Linear(n_channels*32*32, 100)
        scale = (6/(n_channels*32*32+100))**0.5
        torch.nn.init.uniform_(self.fc1.weight, a=-scale, b=scale)
        self.fc2 = nn.Linear(100, n_classes)
        scale = (6/(100+n_classes))**0.5
        torch.nn.init.uniform_(self.fc2.weight, a=-scale, b=scale)


    def forward(self, x):
        x = x.view(x.size(0), -1)
        x = F.softplus(self.fc1(x))
        x = self.fc2(x)
        return x
