# Usage Guide

## Installation

1. Install the required dependencies:
   ```
   pip install -r requirements.txt
   ```

## Running the Models

### Running Improved Mixed Benchmark IRT

```bash
cd model_training
python run_improved_mix_benchmark.py --input_csv path/to/data.csv --output_dir path/to/output
```

### Running Single Benchmark IRT

```bash
cd model_training
python run_benchmark_single.py --input_csv path/to/data.csv --output_dir path/to/output --benchmark CEVAL
```

## Calculating Metrics

```bash
cd metric_calculation
python calculate_extended_metrics.py
```

## Generating Visualizations

```bash
cd visualization
python visualize_model_capabilities.py
```

## Processing Results

```bash
cd results_processing
python summarize_model_capabilities.py
```