# Mix Metric Project

This project contains code for running mixed metric experiments and analyzing model performance across multiple metrics.

## Project Structure

- `model_training/` - Code for training mixed metric models
- `metric_calculation/` - Code for calculating performance metrics
- `visualization/` - Code for generating visualizations
- `results_processing/` - Code for processing and summarizing results
- `utils/` - Utility scripts and helper functions
- `docs/` - Documentation and reports
- `data/` - Data files and datasets

## Core Components

### Model Training
- `modeling_multiple_simple_approach.py` - Implementation of simple approach for multiple metrics
- `modeling_multiple_simple_irt.py` - Implementation of simple IRT for multiple metrics
- `modeling_single.py` - Single metric modeling implementation

### Metric Calculation
- `cal_metric.py` - Core metric calculation functions

### Visualization
- `viz.py` - Visualization functions
- `viz_2.py` - Additional visualization functions

### Results Processing
- `mix_metric.py` - Main script for processing mixed metric results

## Usage

1. Run model training scripts to generate mixed metric model results
2. Use metric calculation scripts to compute performance metrics
3. Generate visualizations using the visualization scripts
4. Process and summarize results with the results processing scripts

## Requirements

- Python 3.x
- PyMC
- ArviZ
- NumPy
- Pandas
- Matplotlib
- Scikit-learn