
# GeoDrag (ICLR 2026 Submission)

This is the official implementation of **GeoDrag**. The code supports interactive editing, batch evaluation on benchmark datasets, and analysis of key metrics.

---

## Installation

We recommend using [Anaconda](https://www.anaconda.com/) to manage dependencies:

```bash
conda env create -f environment.yaml
conda activate geodrag
```

---

## Setup: Checkpoints & Dataset

### 1. Depth Estimation Model

Download the **Depth Anything V2 (ViT-Large)** weights from:

> [depth_anything_v2_vitl.pth](https://huggingface.co/depth-anything/Depth-Anything-V2-Large/resolve/main/depth_anything_v2_vitl.pth)

Then place the file under:

```
GeoDrag/checkpoints/depth_anything_v2_vitl.pth
```

### 2. DragBench Dataset

Download and unzip the benchmark dataset from:

> [DragBench.zip](https://github.com/Yujun-Shi/DragDiffusion/releases/download/v0.1.1/DragBench.zip)

```bash
unzip DragBench.zip -d GeoDrag/data/
```

This will create the dataset directory at:

```
GeoDrag/data/DragBench/
```

---

## Quick Start

### Launch the Interactive Gradio UI:

```bash
python web.py
```

---

## Batch Inference

### Evaluate on DragBench:

```bash
python run_DragBench.py
```

### Run inference on custom samples:

Prepare images and YAML files following the DragBench format:

```bash
python infer.py --sample_path /path/to/your/folder --result_dir /path/to/output/
```

---

## Evaluation Scripts

### 1. LPIPS Similarity

To compare perceptual similarity before and after editing:

```bash
python run_eval_similarity.py
```

### 2. Mean Point Distance

To compute the average distance between predicted and target handle points (estimated using DIFT):

```bash
python run_eval_point_matching.py
```

### 3. DAI (Dragging Accuracy Index)

To evaluate user-consistent editing accuracy:

```bash
python compute_DAI.py
```

---

## Parameter Configuration

The displacement field is controlled by the following parameters:

- `alpha`: Controls spatial influence falloff.
- `beta`: Controls depth-aware modulation strength.
- `gamma_ratio`: Balances geometry- and plane-aware displacement fields.

**Default values**:

```yaml
alpha: 1
beta: 1
gamma_ratio: 1
```
