import json

mask_rates = [0.3, 0.6, 0.9]

param_dict = {'block':[23, 18, 9],
              'patch':[14, 36, 97],
              'indep':[0.7, 0.4, 0.1]}

arg_list = []
for mask_func in param_dict:
    for index, param in enumerate(param_dict[mask_func]):
        arg = {}
        arg['NOTES'] = str(mask_rates[index]) + ' ' + mask_func + ' mask'
        arg['MASK_PARAM'] = param_dict[mask_func][index]
        arg['MASK_FUNCTION'] = mask_func
        arg['METHOD'] = 'approx'
        arg_list.append(arg)
with open('./run_params.json', 'w') as paramfile:
    json.dump(arg_list, paramfile)
