library(missForest)

dataset = read.csv('white.csv', header=FALSE)

true_var <- apply(dataset, 2, sd)^2

nmse <- rnorm(5)

for(i in 1:5){
	dataset.mis <- prodNA(dataset, noNA=0.5)
	missing_count <- apply(is.na(dataset.mis), 2, sum)
	length <- nrow(dataset)
	dataset.imp <- missForest(dataset.mis)
	nmse[i] <- mean(length*colMeans((dataset.imp$ximp - dataset)^2)/(true_var*missing_count))
}

print(mean(nmse))
print(sd(nmse))
