
import scipy as sci
import torch

import numpy as np
import os

from skopt.space import Space
from skopt.sampler import Halton





Tf = 0.5


time_span = np.linspace(0, 0.5, 2000) 

# Define constant


a1 = 2.0
a2 = 0.7
a3 = -0.5
a4 = 2.4
a5 = 0.8
a6 = -2.4
a7 = -1.3
a8 = 0.3
a9 = 2.7
a10 = 2.8
b1 = -0.4
b2 = 3.0
b3 = -1.4
b4 = 1.9
b5 = -0.5
b6 = 3.0
b7 = 1.2
b8 = -1.4
b9 = -0.3
b10 = 1.7
e12 = 1.0
e13 = 0.9
e14 = 0.3
e15 = 0.7
e16 = 1.0
e17 = 1.1
e18 = 0.6
e19 = 1.3
e110 = 1.2
e23 = 1.5
e24 = 0.5
e25 = 0.9
e26 = 0.9
e27 = 1.3
e28 = 1.3
e29 = 0.7
e210 = 1.0
e34 = 1.3
e35 = 1.0
e36 = 0.9
e37 = 1.1
e38 = 1.2
e39 = 1.3
e310 = 1.0
e45 = 0.8
e46 = 1.2
e47 = 1.2
e48 = 0.7
e49 = 0.6
e410 = 1.0
e56 = 1.5
e57 = 0.8
e58 = 1.1
e59 = 0.7
e510 = 1.3
e67 = 0.8
e68 = 1.0
e69 = 1.2
e610 = 1.4
e78 = 1.5
e79 = 1.0
e710 = 0.6
e89 = 0.6
e810 = 0.8
e910 = 1.3





x0 = [0.0,  0.0, 0.0, 0.0, 0.0,  0.0, 0.0, 0.0, 0.0, 0.0, 0.0,  0.0, 0.0, 0.0, 0.0,  0.0, 0.0, 0.0, 0.0, 0.0]

x0 = np.array(x0, dtype="float64")



TestlossV =np.zeros((200)) 
space = Space([(x0[0]-1.0, x0[0]+1.0), (x0[1]-1.0, x0[1]+1.0), (x0[2]-1.0, x0[2]+1.0), (x0[3]-1.0, x0[3]+1.0), (x0[4]-1.0, x0[4]+1.0), (x0[5]-1.0, x0[5]+1.0), (x0[6]-1.0, x0[6]+1.0), (x0[7]-1.0, x0[7]+1.0), (x0[8]-1.0, x0[8]+1.0), (x0[9]-1.0, x0[9]+1.0), (x0[10]-1.0, x0[10]+1.0), (x0[11]-1.0, x0[11]+1.0), (x0[12]-1.0, x0[12]+1.0), (x0[13]-1.0, x0[13]+1.0), (x0[14]-1.0, x0[14]+1.0), (x0[15]-1.0, x0[15]+1.0), (x0[16]-1.0, x0[16]+1.0), (x0[17]-1.0, x0[17]+1.0),(x0[18]-1.0, x0[18]+1.0), (x0[19]-1.0, x0[19]+1.0)])

n_samples = 200
halton = Halton()
start = halton.generate(space.dimensions, n_samples)
start_n = np.array(start, dtype="float64")
initial_data = torch.from_numpy(np.array(start_n)).float()

np.savetxt('Initial_data.txt', initial_data, delimiter=',', newline='\n' )



def DuffingEquations(w, t, a1, a2,a3,a4,a5,a6,a7,a8,a9,a10, b1, b2,b3,b4,b5,b6,b7,b8,b9,b10, e12, e13, e14, e15, e16, e17, e18, e19, e110, e23, e24, e25, e26, e27, e28, e29, e210, e34, e35, e36, e37, e38, e39, e310, e45, e46, e47, e48, e49, e410, e56, e57, e58, e59, e510, e67, e68, e69, e610, e78, e79, e710, e89, e810, e910):
    q = w[...,:10]
    p = w[...,10:20]
   

    q12 = sci.linalg.norm(q)  
    dqdt = p
    dp1dt = - a1*q[0] - b1*q[0]**3 - e12*(q[0] - q[1]) - e13*(q[0] - q[2])   - e14*(q[0] - q[3])   - e15*(q[0] - q[4])   - e16*(q[0] - q[5])   - e17*(q[0] - q[6])   - e18*(q[0] - q[7])   - e19*(q[0] - q[8])   - e110*(q[0] - q[9])     
    dp2dt = - a2*q[1] - b2*q[1]**3 - e12*(q[1] - q[0]) - e23*(q[1] - q[2])   - e24*(q[1] - q[3])   - e25*(q[1] - q[4])   - e26*(q[1] - q[5])   - e27*(q[1] - q[6])   - e28*(q[1] - q[7])   - e29*(q[1] - q[8])   - e210*(q[1] - q[9]) 
    dp3dt = - a3*q[2] - b3*q[2]**3 - e13*(q[2] - q[0]) - e23*(q[2] - q[1])   - e34*(q[2] - q[3])   - e35*(q[2] - q[4])   - e36*(q[2] - q[5])   - e37*(q[2] - q[6])   - e38*(q[2] - q[7])   - e39*(q[2] - q[8])   - e310*(q[2] - q[9]) 
    dp4dt = - a4*q[3] - b4*q[3]**3 - e14*(q[3] - q[0]) - e34*(q[3] - q[2])   - e24*(q[3] - q[1])   - e45*(q[3] - q[4])   - e46*(q[3] - q[5])   - e47*(q[3] - q[6])   - e48*(q[3] - q[7])   - e49*(q[3] - q[8])   - e410*(q[3] - q[9]) 
    dp5dt = - a5*q[4] - b5*q[4]**3 - e15*(q[4] - q[0]) - e35*(q[4] - q[2])   - e45*(q[4] - q[3])   - e25*(q[4] - q[1])   - e56*(q[4] - q[5])   - e57*(q[4] - q[6])   - e58*(q[4] - q[7])   - e59*(q[4] - q[8])   - e510*(q[4] - q[9]) 
    dp6dt = - a6*q[5] - b6*q[5]**3 - e16*(q[5] - q[0]) - e36*(q[5] - q[2])   - e46*(q[5] - q[3])   - e56*(q[5] - q[4])   - e26*(q[5] - q[1])   - e67*(q[5] - q[6])   - e68*(q[5] - q[7])   - e69*(q[5] - q[8])   - e610*(q[5] - q[9]) 
    dp7dt = - a7*q[6] - b7*q[6]**3 - e17*(q[6] - q[0]) - e37*(q[6] - q[2])   - e47*(q[6] - q[3])   - e57*(q[6] - q[4])   - e67*(q[6] - q[5])   - e27*(q[6] - q[1])   - e78*(q[6] - q[7])   - e79*(q[6] - q[8])   - e710*(q[6] - q[9]) 
    dp8dt = - a8*q[7] - b8*q[7]**3 - e18*(q[7] - q[0]) - e38*(q[7] - q[2])   - e48*(q[7] - q[3])   - e58*(q[7] - q[4])   - e68*(q[7] - q[5])   - e78*(q[7] - q[6])   - e28*(q[7] - q[1])   - e89*(q[7] - q[8])   - e810*(q[7] - q[9]) 
    dp9dt = - a9*q[8] - b9*q[8]**3 - e19*(q[8] - q[0]) - e39*(q[8] - q[2])   - e49*(q[8] - q[3])   - e59*(q[8] - q[4])   - e69*(q[8] - q[5])   - e79*(q[8] - q[6])   - e89*(q[8] - q[7])   - e29*(q[8] - q[1])   - e910*(q[8] - q[9]) 
    dp10dt= - a10*q[9] - b10*q[9]**3 - e110*(q[9] - q[0]) - e310*(q[9] - q[2])   - e410*(q[9] - q[3])   - e510*(q[9] - q[4])   - e610*(q[9] - q[5])   - e710*(q[9] - q[6])   - e810*(q[9] - q[7])   - e910*(q[9] - q[8])   - e210*(q[9] - q[1]) 
    
    
    dpdt = np.array([dp1dt, dp2dt,dp3dt,dp4dt,dp5dt,dp6dt,dp7dt,dp8dt,dp9dt,dp10dt])
    
   
    derivs = np.concatenate((dqdt, dpdt))
    return derivs



import scipy.integrate



q01 = np.zeros((n_samples,2000,20))

end_q0 = np.zeros((n_samples,20))


for x1 in range(n_samples):
    init_params = start[x1]
    init_params = np.array(init_params, dtype="float64")
    init_params = init_params.flatten()
    
    sol01 = sci.integrate.odeint(DuffingEquations, init_params, time_span, args=(a1, a2,a3,a4,a5,a6,a7,a8,a9,a10, b1, b2,b3,b4,b5,b6,b7,b8,b9,b10, e12, e13, e14, e15, e16, e17, e18, e19, e110, e23, e24, e25, e26, e27, e28, e29, e210, e34, e35, e36, e37, e38, e39, e310, e45, e46, e47, e48, e49, e410, e56, e57, e58, e59, e510, e67, e68, e69, e610, e78, e79, e710, e89, e810, e910), rtol=1e-13, atol=1e-14)

 
                    

    end_q0[x1] = sol01[-1,0:20]
    
    
    



np.savetxt('Final_points.txt', end_q0, delimiter=',', newline='\n' )