import torch
from torch import nn
from torch import optim
import torch.nn.functional as F

class LeNet(nn.Module):
    def __init__(self):
        super(LeNet, self).__init__()
        self.conv1 = nn.Conv2d(1, 20, 5, 1)
        self.conv2 = nn.Conv2d(20, 50, 5, 1)
        self.fc1 = nn.Linear(4*4*50, 500)
        self.fc2 = nn.Linear(500, 10)
    def forward(self, x):
        activations = []
        linearCombs = []
        x = F.relu(self.conv1(x))
        x = F.max_pool2d(x, 2, 2)
        x = F.relu(self.conv2(x))
        x = F.max_pool2d(x, 2, 2)
        x = x.view(-1, 4*4*50)
        x = F.relu(self.fc1(x))
        activations.append(x)
        x = self.fc2(x)
        x.retain_grad()
        x.requires_grad_(True)
        linearCombs.append(x)
        return x, activations, linearCombs


def conv_mnist():
    model = LeNet()
    return model
def conv_fashion():
    model = LeNet()
    return model
